#include "mbed.h"
#include "Watchdog.h"

void Watchdog::kick(int WDTseconds) {
    if(WDTseconds < 1) WDTseconds = 1;      //minimum watchdog time is 1 sec
    if(WDTseconds > 134) WDTseconds = 134;  //maximum watchdog time is 134 sec
    LPC_WDT->TC = 125000 * WDTseconds;      //125000 * 8uS = 1.0 second tics
    LPC_WDT->MOD = 0x3;                     //enable and restart watchdog
    Watchdog::kick();
}

void Watchdog::kick() {
    LPC_WDT->FEED = 0xaa;                   //kick sequence into FEED register
    LPC_WDT->FEED = 0x55;
}
