#ifndef WATCHDOG_4088_H
#define WATCHDOG_4088_H

#include "mbed.h"

/** Routines to set and kick the Watchdog timer for the LPC4088.
 *
 *   The LPC4088 has a fixed, internal 500KHz oscillator which
 *   is divided by 4 to give an 8uS master clock to the Watchdog countdown timer.
 *
 *   User inputs a value from 1 to 134 seconds when initializing the Watchdog
 *   timer. The user's input number is multiplied by 125k and then placed into 
 *   the countdown timer.
 *
 *   The user is responsible for "kicking" the Watchdog before the timeout interval 
 *   expires, otherwise the LPC4088 will automatically reboot.
 *
 * @code
 * #include "mbed.h"
 * #include "Watchdog.h" 
 *
 * Watchdog wdt;
 *
 * int main() {
 *     initialization code....
 *     wdt.kick(20);           //init the watchdog for a 20 second timeout
 *     while(1) {
 *         wait_ms(1000);      //do some code
 *         wdt.kick();         //kick the watchdog before 20 seconds is up
 *     }
 * }
 * @endcode
 *
 */
/* Watchdog controller class
 */
class Watchdog {

public:
    /** Create a Watchdog object and initialize timeout in seconds
     *
     * @param int timeout in seconds. Range (1 - 134)
     */
    void kick(int WDTseconds);
    
    
    /** Keep alive by kicking the Watchdog occasionally
     *
     * @param NONE
     */
    void kick();

private:
    int WDTseconds;
};

#endif
