#include "mbed.h"
#include "PrintBuffer.h"

extern RawSerial pc;
//const char ESC = 0x1b;                      //ascii escape

#define DOBLACK     "\033[0;30;2m"
#define DORED       "\033[0;31;2m"
#define DOGREEN     "\033[0;32;2m"
#define DOYELLOW    "\033[0;33;2m"
#define DOBLUE      "\033[0;34;2m"
#define DOMAGENTA   "\033[0;35;2m"
#define DOCYAN      "\033[0;36;2m"
#define DOWHITE     "\033[0;37;2m"
#define DODEFAULT   "\033[0;39;2m"
#define DONONE      "\033[0m"

// Constructor
PrintBuffer::PrintBuffer(const char* name) {
}

//--------------------------------------------------------------------------------------------------------------------------------------//
// Used for doing a hex and ascii dump of the buffer.  BufferLines tells PrintBuffer how
// many 16 byte lines to print.

int PrintBuffer::dump(const char* title, int BufferLines, int BufferOffset, const char buffer[]) {
    pc.printf("\n%s%s - lines: %d   starting at: 0x%04x%s\r\n", DOMAGENTA, title, BufferLines, BufferOffset, DONONE);
    for(int i = BufferOffset; i < BufferLines * 16 + BufferOffset; i = i + 16) {
        pc.printf("%04x  ", i);
        for(int s = 0; s < 8; s++) {
            pc.printf("%02x ", buffer [s + i]);
        }
        pc.printf("  ");
        for(int s = 0; s < 8; s++) {
            pc.printf("%02x ", buffer[s + i + 8]);
        }
        pc.printf("  ");
        for(int s = 0; s < 8; s++) {
            if((buffer[s + i] < 0x20) || (buffer[s + i] > 0x7f)) { 
                pc.printf("%s.%s", DOCYAN, DONONE);
            } else {
                pc.printf("%c", buffer[s + i]);
            }
        }
        pc.printf(" ");
        for(int s = 0; s < 8; s++) {
            if((buffer[s + i + 8] < 0x20) || (buffer[s + i + 8] > 0x7f)) { 
                pc.printf("%s.%s", DOCYAN, DONONE);
            } else {
                pc.printf("%c", buffer[s + i + 8]);
            }
        }
        pc.printf("\r\n");
    }
    pc.printf("\r\n");
    return(0);
}

//--------------------------------------------------------------------------------------------------------------------------------------//
// Used for doing a hex and ascii dump of the buffer.  BufferLines tells PrintBuffer how
// many 16 byte lines to print.  Added external ability to add to the buffer base address for display purposes

int PrintBuffer::dump_a(const char* title, int BufferLines, int BufferOffset, const char buffer[], int addr) {
    pc.printf("\n%s%s - lines: %d   starting at: 0x%04x%s\r\n", DOMAGENTA, title, BufferLines, BufferOffset + addr, DONONE);
    for(int i = BufferOffset; i < BufferLines * 16 + BufferOffset; i = i + 16) {
        pc.printf("%04x_%04x  ", (i + addr) >> 16, (i + addr) & 0xffff);
        for(int s = 0; s < 8; s++) {
            pc.printf("%02x ", buffer [s + i]);
        }
        pc.printf("  ");
        for(int s = 0; s < 8; s++) {
            pc.printf("%02x ", buffer[s + i + 8]);
        }
        pc.printf("  ");
        for(int s = 0; s < 8; s++) {
            if((buffer[s + i] < 0x20) || (buffer[s + i] > 0x7f)) { 
                pc.printf("%s.%s", DOCYAN, DONONE);
            } else {
                pc.printf("%c", buffer[s + i]);
            }
        }
        pc.printf(" ");
        for(int s = 0; s < 8; s++) {
            if((buffer[s + i + 8] < 0x20) || (buffer[s + i + 8] > 0x7f)) { 
                pc.printf("%s.%s", DOCYAN, DONONE);
            } else {
                pc.printf("%c", buffer[s + i + 8]);
            }
        }
        pc.printf("\r\n");
    }
    pc.printf("\r\n");
    return(0);
}

//--------------------------------------------------------------------------------------------------------------------------------------//
// Used for doing a hex and ascii dump of the buffer.  BufferLines tells PrintBuffer how
// many 16 byte lines to print.

int PrintBuffer::dump_t(const char* title, int BufferLines, int BufferOffset, const uint8_t buffer[]) {
    pc.printf("\n%s%s - lines: %d   starting at: 0x%04x%s\r\n", DOMAGENTA, title, BufferLines, BufferOffset, DONONE);
    for(int i = BufferOffset; i < BufferLines * 16 + BufferOffset; i = i + 16) {
        pc.printf("%04x  ", i);
        for(int s = 0; s < 8; s++) {
            pc.printf("%02x ", buffer [s + i]);
        }
        pc.printf("  ");
        for(int s = 0; s < 8; s++) {
            pc.printf("%02x ", buffer[s + i + 8]);
        }
        pc.printf("  ");
        for(int s = 0; s < 8; s++) {
            if((buffer[s + i] < 0x20) || (buffer[s + i] > 0x7f)) { 
                pc.printf("%s.%s", DOCYAN, DONONE);
            } else {
                pc.printf("%c", buffer[s + i]);
            }
        }
        pc.printf(" ");
        for(int s = 0; s < 8; s++) {
            if((buffer[s + i + 8] < 0x20) || (buffer[s + i + 8] > 0x7f)) { 
                pc.printf("%s.%s", DOCYAN, DONONE);
            } else {
                pc.printf("%c", buffer[s + i + 8]);
            }
        }
        pc.printf("\r\n");
    }
    pc.printf("\r\n");
    return(0);
}

//--------------------------------------------------------------------------------------------------------------------------------------//
// Used for doing a hex and ascii dump of the buffer.  BufferLines tells PrintBuffer how
// many 16 byte lines to print.

int PrintBuffer::dump_uc(const char* title, int BufferLines, int BufferOffset, const unsigned char buffer[]) {
    pc.printf("\n%s%s - lines: %d   starting at: 0x%04x%s\r\n", DOMAGENTA, title, BufferLines, BufferOffset, DONONE);
    for(int i = BufferOffset; i < BufferLines * 16 + BufferOffset; i = i + 16) {
        pc.printf("%04x  ", i);
        for(int s = 0; s < 8; s++) {
            pc.printf("%02x ", buffer [s + i]);
        }
        pc.printf("  ");
        for(int s = 0; s < 8; s++) {
            pc.printf("%02x ", buffer[s + i + 8]);
        }
        pc.printf("  ");
        for(int s = 0; s < 8; s++) {
            if((buffer[s + i] < 0x20) || (buffer[s + i] > 0x7f)) { 
                pc.printf("%s.%s", DOCYAN, DONONE);
            } else {
                pc.printf("%c", buffer[s + i]);
            }
        }
        pc.printf(" ");
        for(int s = 0; s < 8; s++) {
            if((buffer[s + i + 8] < 0x20) || (buffer[s + i + 8] > 0x7f)) { 
                pc.printf("%s.%s", DOCYAN, DONONE);
            } else {
                pc.printf("%c", buffer[s + i + 8]);
            }
        }
        pc.printf("\r\n");
    }
    pc.printf("\r\n");
    return(0);
}


