#include "LCDclockSet.h"
#include "button_group.hpp"

extern LCD_DISCO_F746NG lcd;
extern uint8_t lcd_text[];

//--------------------------------------------------------------------------------------------------------------------------------------//
// Constructor and destructor

LCDclockSet::LCDclockSet(const char* name) {
}

//--------------------------------------------------------------------------------------------------------------------------------------//
// Draw 6 blocks with a special character in between for setting clock date and time

const uint16_t SIZE_CLKBLK = 30;
const uint16_t GAP_CLKBLK = 5;
const uint16_t WIDEGAP_CLKBLK = 24;
   
const uint16_t PX13_CLKBLK = 90;
const uint16_t PY13_CLKBLK = 60;
        
void LCDclockSet::DrawClockBlock(char chr) {
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    int nBlocks = 2;
    uint16_t tX = PX13_CLKBLK;
    uint16_t tY = PY13_CLKBLK;
    for(int q = 0; q < 3; q++) {
        lcd.SetBackColor(LCD_COLOR_BLACK);
        lcd.SetTextColor(LCD_COLOR_GRAY);
        for(int i = 0; i < nBlocks; i++) {
            lcd.FillRect(tX, tY, SIZE_CLKBLK, SIZE_CLKBLK);
            lcd.DrawLine(tX, tY + SIZE_CLKBLK + 3, tX + SIZE_CLKBLK - 1, tY + SIZE_CLKBLK + 3);
            tX = tX + SIZE_CLKBLK + GAP_CLKBLK;
        }
        lcd.SetBackColor(LCD_COLOR_BLACK);
        lcd.SetTextColor(LCD_COLOR_CYAN);
        lcd.SetFont(&Font24);
        if(q != 2) {
            lcd.DisplayChar(tX + GAP_CLKBLK - 5, tY + 5, chr);
        }
        tX = tX + WIDEGAP_CLKBLK;
    }
    lcd.SetTextColor(LCD_COLOR_CYAN);
    lcd.SetFont(&Font16);
    lcd.SetTextColor(LCD_COLOR_CYAN);
    if(chr == ':') {
        sprintf((char*)lcd_text, "Set 24hr time:  hh:mm:ss");
    } else {
        sprintf((char*)lcd_text, "   Set date:  mm/dd/yy");
    }
    lcd.DisplayStringAt(PX13_CLKBLK - 7, 40, (uint8_t *)&lcd_text, LEFT_MODE);
}

//--------------------------------------------------------------------------------------------------------------------------------------//
//Constants for 12 block

const int SIZE_12BLK = 35;
const int GAP_12BLK = 10;
   
const int PX13_12BLK = PX13_CLKBLK - 3;         //starting X for blocks
const int PY13_12BLK = 130;                     //starting Y for blocks

//--------------------------------------------------------------------------------------------------------------------------------------//
//Convert a touch to a number on one of the 6 blocks.  Block number is 1 - 6 only!!!!

void LCDclockSet::TouchClockBlock(int block_number, int value, bool erase) {
    int tX = PX13_CLKBLK + (block_number - 1) * (SIZE_CLKBLK + GAP_CLKBLK);
    int tY = PY13_CLKBLK;
    if(block_number > 4) tX = tX + WIDEGAP_CLKBLK;
    if(block_number > 2) tX = tX + WIDEGAP_CLKBLK;
    if (erase == true) {
        lcd.SetTextColor(LCD_COLOR_DARKGRAY);
        lcd.FillRect(tX, tY, SIZE_CLKBLK, SIZE_CLKBLK);
        return;
    } else {
        lcd.SetFont(&Font24);
        lcd.SetBackColor(LCD_COLOR_YELLOW);
        lcd.SetTextColor(LCD_COLOR_DARKGREEN);
        lcd.FillRect(tX, tY, SIZE_CLKBLK, SIZE_CLKBLK);
        sprintf((char*)lcd_text, "%d", value);
        lcd.DisplayStringAt(tX + 4, tY + 4, (uint8_t *)&lcd_text, LEFT_MODE);
    }
}

//--------------------------------------------------------------------------------------------------------------------------------------//
//Draw 2 rows of 6 blocks and put numbers inside the blocks for later touch.  In addition, add 2 more blocks to the 
//right with special characters
        
void LCDclockSet::Draw12Block(int rot, uint32_t block_color, uint32_t text_color) {
    int nBlocks = 5;
    uint16_t tX = PX13_12BLK;
    uint16_t tY = PY13_12BLK;
    
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(block_color);
    for(int i = 0; i < nBlocks + 1; i++) {
        lcd.SetTextColor(block_color);
        lcd.DrawRect(tX, tY, SIZE_12BLK, SIZE_12BLK);
        tX = tX + SIZE_12BLK + GAP_12BLK;
    }
    tX = tX - (nBlocks + 1) * (SIZE_12BLK + GAP_12BLK);
    tY = tY + SIZE_12BLK + GAP_12BLK;
    for(int i = 0; i < nBlocks + 1; i++) {
        lcd.DrawRect(tX, tY, SIZE_12BLK, SIZE_12BLK);
        tX = tX + SIZE_12BLK + GAP_12BLK;
    }
    lcd.SetTextColor(text_color);
    lcd.SetFont(&Font24);
    tX = tX - (nBlocks + 1) * (SIZE_12BLK + GAP_12BLK) + 7;
    tY = tY - (SIZE_12BLK + GAP_12BLK) + 7;
    for(int i = 1; i < nBlocks + 1; i++) {
        sprintf((char*)lcd_text, "%d", i);
        lcd.DisplayStringAt(tX, tY, (uint8_t *)&lcd_text, LEFT_MODE);
        tX = tX + SIZE_12BLK + GAP_12BLK;
    }
    lcd.DisplayChar(tX, tY, '<');
    tX = tX - nBlocks * (SIZE_12BLK + GAP_12BLK);
    tY = tY + SIZE_12BLK + GAP_12BLK;
    for(int i = 6; i < nBlocks + 5; i++) {
        sprintf((char*)lcd_text, "%d", i);
        lcd.DisplayStringAt(tX, tY, (uint8_t *)&lcd_text, LEFT_MODE);
        tX = tX + SIZE_12BLK + GAP_12BLK;
    }
    lcd.DisplayChar(tX, tY, '0');
    tX = tX + SIZE_12BLK + GAP_12BLK;
    lcd.DisplayChar(tX, tY, '#');
}

//--------------------------------------------------------------------------------------------------------------------------------------//
// looking to see if a "touch" lands in 1 of the 10 number blocks.  If pen is detected inside one of the numbers from 0-9, that number is returned.
// if the number is not detected, the number 255 is returned

int LCDclockSet::Touch12Block(uint16_t x, uint16_t y) {
    uint16_t tX = PX13_12BLK;
    uint16_t tY = PY13_12BLK;

    for(int i = 0; i < 6; i++) {
        if((x > (tX + i * (SIZE_12BLK + GAP_12BLK))) && (x < (tX + SIZE_12BLK + i * (SIZE_12BLK + GAP_12BLK))) && (y > tY) && (y < (tY + SIZE_12BLK))) {
            if(i == 5) {
                return('<');    //return <
            }
            return(i + 1);      //return 1-5
        }
    }
    tY = tY + SIZE_12BLK + GAP_12BLK;
    for(int i = 0; i < 7; i++) {
        if((x > (tX + i * (SIZE_12BLK + GAP_12BLK))) && (x < (tX + SIZE_12BLK + i * (SIZE_12BLK + GAP_12BLK))) && (y > tY) && (y < (tY + SIZE_12BLK))) {
            if(i == 4) {
                return(0);      //return 0
            }
            if(i == 5) {
                return('#');    //return #
            }
            return(i + 6);      //return 6-9
        }
    }
    return(255);                //return 10 = error!!
}
