#include "mbed.h"
#include "EthernetInterface.h"
#include "k64f_EthLink.h"

EthernetInterface eth;
k64fEthLink link;
Serial pc(USBTX, USBRX);

//--------------------------------------------------------------------------------------------------------------------------------------//
// Check for a valid Ethernet Link, print ONLY on status change and keep count of link "downs"

bool EthPhyUpT = false;
int EthUpDownCnt = 0;

int TestEthLink() {
    int EthLinkStat = link.GetELink();
    if((!(EthLinkStat)) && (EthPhyUpT == false)) {
        pc.printf("Eth Link UP\r\n");
        EthPhyUpT = true;
    } else if(((EthLinkStat)) && (EthPhyUpT == true)){
        EthUpDownCnt++;
        pc.printf("Eth Link DOWN, count: %d\r\n", EthUpDownCnt);
        EthPhyUpT = false;
    }
    if(EthLinkStat == MDIO_TIMEOUT) return(MDIO_TIMEOUT);
    if(EthPhyUpT == true) return(PHY_UP);
    return(PHY_DOWN);
}

//--------------------------------------------------------------------------------------------------------------------------------------//

int main() {
    pc.baud(230400);
    pc.printf("\r\n\r\nBasic Ethernet Link Up / Down test for K64F\r\n");
    int EthInitStatus = eth.init();
    
    /* Finish up initialization here!!! */
    
    while(1) {
        Thread::wait(500);
        int i = TestEthLink();
        if(i == MDIO_TIMEOUT) pc.printf("MDIO Timeout!!!\r\n");
    }
}
