#include "mbed.h"
#include "FATFileSystem.h"
#include "SDBlockDevice.h"

DigitalOut gpo(D0);
DigitalOut led(LED_RED);

RawSerial pc(USBTX, USBRX);
SDBlockDevice sd(MBED_CONF_SD_SPI_MOSI, MBED_CONF_SD_SPI_MISO, MBED_CONF_SD_SPI_CLK, MBED_CONF_SD_SPI_CS);
FATFileSystem fs("sd", &sd);

//--------------------------------------------------------------------------------------------------------------------------------------//
// Initialize the file system

#define FS_INIT_FILENAME "/sd/hello.txt"

void initFS() {
    pc.printf("Initializing the SDFileSystem...\r\n");
    FILE* fhr = fopen(FS_INIT_FILENAME, "r");
    if(fhr != NULL) {
        fclose(fhr);
        pc.printf("Found test file %s\r\n...", FS_INIT_FILENAME);
    } else {
        pc.printf("File: %s not found. Creating\r\n", FS_INIT_FILENAME);
        FILE* fhw = fopen(FS_INIT_FILENAME, "w");
        if(fhw != NULL) {
            fwrite("Hello World!", 12, 1, fhw);
            fprintf(fhw, "Hello World!\n");
            fclose(fhw);
        } else {
            pc.printf("*** Cannot write file: %s\r\n", FS_INIT_FILENAME);
        }
    }
}

//--------------------------------------------------------------------------------------------------------------------------------------//
// main

int main() {
    pc.baud(230400);
    pc.printf("\r\n\r\n--------------------------------------------------------------------------------\r\n");
    pc.printf("FRDM-K64F + OS5 + FS");
    pc.printf("   -> build: " __DATE__ " " __TIME__ "(UTC)  K Braun\n");
    initFS();
    while (true) {
        gpo = !gpo; // toggle pin
        led = !led; // toggle led
        wait(0.2f);
    }
}