#include "mbed.h"
#include "HTTPServer.h"
#include "HTTPRPC.h"
#include "HTTPFS.h"

#include "TextLCD.h"  //kb
#include "myrpc.h"


HTTPServer http;

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30); // rs, rw, e, d0, d1, d2, d3

myrpc myrpc1(LED1, "myrpc1");
myrpc myrpc2(LED2, "myrpc2");
myrpc myrpc3(LED3, "myrpc3");
myrpc myrpc4(LED4, "myrpc4");

LocalFileSystem local("local");
Ethernet eth2;

float const DISP_SLOW(2.0);
float const DISP_FAST(0.5);

// Once running, try this web page ->  http://192.168.1.102/rpc/led3/write+1

/* Display the MAC address on the Text LCD */
void disp_mac() {
    lcd.cls();
    lcd.printf("MAC: ");
    lcd.locate(0,1);         //column(0-15), row(0-1)
        char dispchar, mac_addr[6], i;
        eth2.address(mac_addr);        
        for(i = 0; i < 3; i++) { 
            dispchar = mac_addr[i]; 
                if(dispchar < 16) { lcd.printf("0", dispchar);
                }
            lcd.printf("%x", dispchar); 
        }
        for(i = i; i < 6; i++) { 
            dispchar = mac_addr[i]; 
                lcd.printf(":", dispchar); 
                if(dispchar < 16) { lcd.printf("0", dispchar);
                }
            lcd.printf("%x", dispchar); 
        }  
/* Display done */  
}

/* Display Waiting for Link */
void disp_linkStat() {
    lcd.cls();
    while(eth2.link() == 0) {
        led2 = !led2;
        wait(DISP_FAST);
        lcd.cls();
        lcd.printf("Link DOWN");  
    }
    led2 = 0;
    lcd.cls();
    lcd.printf("Link UP");     
/* Display done */
}    

/* Display the IP Address on the Text LCD */
void disp_ipAddr() {
    NetServer *net = NetServer::get();
    struct ip_addr ip = net->getIPAddr();
    lcd.cls();
    lcd.printf("IP:");
    lcd.locate(0,1);         //column(0-15), row(0-1)
    lcd.printf("%hhu.%hhu.%hhu.%hhu\n", (ip.addr)&0xFF, (ip.addr>>8)&0xFF, (ip.addr>>16)&0xFF, (ip.addr>>24)&0xFF);
/* Display done */
}        

/* Display the IP Address Mask on the Text LCD */
void disp_ipMask() {
    NetServer *net = NetServer::get();
    struct ip_addr nm = net->getNetmask();
    lcd.cls();
    lcd.printf("Mask:");
    lcd.locate(0,1);         //column(0-15), row(0-1)
    lcd.printf("%hhu.%hhu.%hhu.%hhu\n", (nm.addr)&0xFF, (nm.addr>>8)&0xFF, (nm.addr>>16)&0xFF, (nm.addr>>24)&0xFF);
/* Display done */
}    
  
/* Display the IP Gateway Address on the Text LCD */
void disp_ipGateway() {
    NetServer *net = NetServer::get();
    struct ip_addr gw = net->getGateway();
    lcd.cls();
    lcd.printf("GW:");
    lcd.locate(0,1);         //column(0-15), row(0-1)
    lcd.printf("%hhu.%hhu.%hhu.%hhu\n", (gw.addr)&0xFF, (gw.addr>>8)&0xFF, (gw.addr>>16)&0xFF, (gw.addr>>24)&0xFF);
/* Display done */
}

/* Display the DNS IP Address on the Text LCD */
void disp_ipDNS() {
    NetServer *net = NetServer::get();
    struct ip_addr dns = net->getDNS1();
    lcd.cls();
    lcd.printf("DNS:");
    lcd.locate(0,1);         //column(0-15), row(0-1)
    lcd.printf("%hhu.%hhu.%hhu.%hhu\n", (dns.addr)&0xFF, (dns.addr>>8)&0xFF, (dns.addr>>16)&0xFF, (dns.addr>>24)&0xFF);
/* Display done */
}


int main(void) {
    
    /* Init the LCD */
    lcd.cls();
    lcd.locate(0,0);         //column(0-15), row(0-1)
    lcd.printf("Init HTTP Serv 9");
    lcd.locate(0,1);         //column(0-15), row(0-1)
    lcd.printf("K Braun");
    wait(DISP_SLOW);
    /* Display done */
    
    char time_buff[32];
    lcd.cls();
    time_t seconds = time(NULL);
    strftime(time_buff, 32, "%a %m/%d/%y\n" /*%I:%M:%S %p\n"*/, localtime(&seconds));
    lcd.printf("%s", time_buff);
    strftime(time_buff, 32, /*"%a %m/%d/%y\n"*/ "%I:%M:%S %p\n", localtime(&seconds));
    lcd.printf("%s", time_buff);
    wait(DISP_SLOW);
    
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<AnalogOut>();
    Base::add_rpc_class<BusIn>();
    Base::add_rpc_class<BusInOut>();
    Base::add_rpc_class<BusOut>();
//    Base::add_rpc_class<CAN>();
    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalInOut>();    
    Base::add_rpc_class<DigitalOut>();
//    Base::add_rpc_class<Ethernet>();
//    Base::add_rpc_class<I2C>();
//    Base::add_rpc_class<InterruptIn>();
//    Base::add_rpc_class<LocalFileSystem>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<SPI>();
    Base::add_rpc_class<Serial>();
//    Base::add_rpc_class<Ticker>();
//    Base::add_rpc_class<Timeout>();
    Base::add_rpc_class<Timer>();
//    Base::add_rpc_class<error>(); 
//    Base::add_rpc_class<rtc_time>();

    Base::add_rpc_class<myrpc>();
               
    disp_mac();  //put MAC address on LCD
    wait (DISP_SLOW); 
    disp_linkStat();  //show link status on LCD, wait for valid link
    wait (DISP_FAST); 
    lcd.cls();
    lcd.printf("Looking for...\n");
    lcd.printf("DHCP Server");
    http.addHandler(new HTTPRPC());
    http.addHandler(new HTTPFileSystemHandler("/", "/local/"));
    http.bind();
    
//    server.addHandler(new HTTPFS("/", "/local/"));
//    server.bind();
//    NetServer *net = NULL;    
    NetServer *net = NetServer::get();
//    struct ip_addr ip = net->getIPAddr();
//    struct ip_addr gw = net->getGateway();
//    struct ip_addr nm = net->getNetmask();
//    struct ip_addr dns = net->getDNS1();
//    struct ip_addr hn = net->getHostname();
    // ...

    /* Display the Host Name on the Text LCD */
    lcd.cls();
    lcd.printf("Host:");
    lcd.locate(0,1);         //column(0-15), row(0-1)
//    hn((char *)net->getHostname);
    lcd.printf("mbed-c3p0");  //<<until I can find out "how-to", force feed "mbed-c3p0"
//    lcd.printf("%s", (const char)net->getHostname));
    wait(DISP_FAST);
    /* Display done */

    disp_ipAddr();    //put IP address on LCD
    wait (DISP_FAST); 
    disp_ipMask();    //put IP Mask on LCD
    wait (DISP_FAST); 
    disp_ipGateway(); //put Gateway address on LCD
    wait (DISP_FAST);
    disp_ipDNS();     //put DNS address on LCD
    wait (DISP_FAST);  
    disp_ipAddr();    //put IP address on LCD...again
    lcd.printf("mbed-c3p0");  //<<until I can find out "how-to", force feed "mbed-c3p0"       

    while(1) {
        http.poll();
        disp_ipAddr();    //put IP address on LCD...again
        lcd.printf("mbed-c3p0");  //<<until I can find out "how-to", force feed "mbed-c3p0"  
        time_t seconds = time(NULL);
        strftime(time_buff, 32, /*"%a %m/%d/%y\n"*/ "  %H:%M\n", localtime(&seconds));
        lcd.printf("%s", time_buff);
        wait(0.01);
    }
}

