#include "mbed.h"
#include "Color565.h"
#include "font_IBM.h"
#include "LCD_ST7735.h"
#pragma once

class Game {    
    static const char* LOSE_1;
    static const char* LOSE_2;
    static const char* SPLASH_1;
    static const char* SPLASH_2;
    static const char* LIVES;
    static const char* SCORE;
    
    static const int BALL_RADIUS = 2;
    static const int BALL_STARTING_SPEED = 3;
    static const int PADDLE_WIDTH = 38;
    static const int PADDLE_HEIGHT = 4;
    static const int PADDLE_SPEED = 5;
    static const int BOUNCE_SOUND_TICKS = 2;
    static const char I2C_ADDR = 0x1C << 1;

    static const int CHAR_WIDTH = 8;
    static const int CHAR_HEIGHT = 8;
    static const int CHAR_SPACING = 0;
    
    static const float MAX_SPEED = 6.0f;
    // Start with a ball.. let's see what becomes
    int ballX;
    int ballY;
    float ballSpeedX;
    float ballSpeedY;
    float ballAccelX;
    float ballAccelY;
    int pwmTicksLeft;
    int lives;
    int score;
    bool lastUp;
    bool lastDown;
    bool muted;
    unsigned short colors[3];
    unsigned short cCol;
    DigitalIn left;
    DigitalIn right;
    DigitalIn down;
    DigitalIn up;
    DigitalIn square;
    DigitalIn circle; 
    DigitalOut led1;
    DigitalOut led2;
    PwmOut pwm;
    AnalogIn ain;
    I2C i2c;
    LCD_ST7735 disp;
    
    void readRegisters(char address, char* buffer, int len);
    int writeRegister(char address, char value);
    void getXY(float& x, float& y);

    double convert(char* buffer);
    void printDouble(double value, int x, int y);
    
    void initialize();
    void initializeBall();
    
    void drawString(const char* str, int y);
    void clearBall();
    void drawBall();
    void updateBall();
    void readAccel();
    void bounce();
    void checkButtons();
    void checkCollision();
    void checkPwm();
    void checkLives();
    
    public:
        Game();
        
        void showSplashScreen();
        void tick();
};