#include "mbed.h"
#include "sound.h"
#include "LCD_ST7735.h"
#include "font_IBM.h"
//#include "Sequencer.h"

//int main() {
//    Sequencer seq;
//    while (true) {
//        wait(10.0f);
        //    seq.play();
//    }
    
Ticker flipper;
LCD_ST7735 disp(P0_19, P0_20, P0_7, P0_21, P0_22, P1_15, P0_2, LCD_ST7735::RGB);
// led1(P0_9), led2(P0_8), pwm(P0_18)
PwmOut pwm(P0_18);
DigitalOut led1(P0_9);
DigitalOut led2(P0_8);
InterruptIn left(P0_14);
InterruptIn right(P0_11);
InterruptIn up(P0_13);
InterruptIn down(P0_12);

double srate = 1.0f/2000.0f;
double pwmrate = 1.0f/80000.0f;
unsigned short int idx = 0;

void printDouble(int y, double value) {
    char buffer[10];
    int len = sprintf(buffer, "%.1f", value);
    disp.drawString(font_ibm, 0, y, buffer);
}
void pnext() {
    pwm = (pcm_samples[idx++] / 255.0f);
    if (idx == pcm_length) {
      idx = 0;
      led2 = !led2;
    }
}

void setpwm() {
    led1 = !led1;
    printDouble(10, 1.0f/pwmrate);
    pwm.period(pwmrate);
}
void setsrate() {
    flipper.detach();
    led2 = !led2;
    printDouble(0, 1.0f/srate);
    flipper.attach(&pnext, srate); // setup flipper to call flip after 2 seconds
}
void incf() {
    srate *= 1.1f;
    setsrate();    
}
void decf() {
    srate /= 1.1f;
    setsrate();    
}
void incpwm() {
    pwmrate *= 1.1f;
    setpwm();
}
void decpwm() {
    pwmrate /= 1.1f;
    setpwm();
}
int main() {
    led2 = 1;
    pwm.period(pwmrate);
    left.mode(PullUp);
    right.mode(PullUp);
    up.mode(PullUp);
    down.mode(PullUp);

    right.rise(&incpwm);
    left.rise(&decpwm);
    up.rise(&incf);
    down.rise(&decf);

    disp.setOrientation(LCD_ST7735::Rotate270, false);    
    disp.clearScreen();
    printDouble(0 , 1.0f/srate);
    printDouble(10, 1.0f/pwmrate);

    flipper.attach(&pnext, srate); // setup flipper to call flip after 2 seconds
    led1 = 1;
    
    while(1) {
        // Watchdog. Have I crashed?
        wait(10.0f);
        led1 = !led1;
    }
}
