/**
 * @file MAX6955.h
 * @brief MAX6955 I2C driver
 *
 */

#ifndef MAX6955_H
#define MAX6955_H

#include "mbed.h"

// max6955 commands
#define reg_noOp 0x00
#define reg_decodeMode 0x01
#define reg_globalIntensity 0x02
#define reg_scanLimit 0x03
#define reg_configuration 0x04
#define reg_displayTest 0x07
#define reg_digitType 0x0C

#define reg_intensity10 0x10
#define reg_intensity32 0x11
#define reg_intensity54 0x12
#define reg_intensity76 0x13
#define reg_intensity10a 0x14
#define reg_intensity32a 0x15
#define reg_intensity54a 0x16
#define reg_intensity76a 0x17

#define USE_GLOBAL 0x00
#define USE_DISCRETE 0x40
#define RUN 0x01
#define SHUTDOWN 0x00

#define reg_digit0 0x60
#define reg_digit1 0x61
#define reg_digit2 0x62
#define reg_digit3 0x63
#define reg_digit4 0x64
#define reg_digit5 0x65
#define reg_digit6 0x66
#define reg_digit7 0x67
#define reg_digit0a 0x68
#define reg_digit1a 0x69
#define reg_digit2a 0x6A
#define reg_digit3a 0x6B
#define reg_digit4a 0x6C
#define reg_digit5a 0x6D
#define reg_digit6a 0x6E
#define reg_digit7a 0x6F


class MAX6955 {
    public:
        /* 
         * @param sda mbed pin for I2C SDA
         * @param scl mbed pin for I2C SCL
         * @param driver I2C device address
         */
        MAX6955(PinName sda, PinName scl, char driver); 

        /**
         * @brief This function writes command and data.
         *
         * @param command
         *     MAX6955 command.
         * @param data
         *     data to write.
         *
         * @return[int] result
         */
        int write(char command, char data);


        /**
         * @brief This function writes string.
         *
         * @param pointer to buffer
         *
         * @return result
         */
        int writeS(char* buffer);


        /**
         * @brief init function.
         *
         * @return result
         */
        int init(void);
        
    private:
        I2C i2c_;
        char driver_;
};

#endif