/**
 * @file MAX6955.cpp
 */

#include "MAX6955.h"

MAX6955::MAX6955(PinName sda, PinName scl, char driver): i2c_(sda, scl), driver_(driver){}

static char getPrintableChar(char c) {
    if (c < 32 || c > 126) { // make sure its printable
        return 32; // if not, replace it with "space"
    }
    return c;
}

static char* getString(char* buffer) {
    static char i2cData[9];
    i2cData[0] = 0x20; // first digit
    for (int i = 0; i < 8; i++) {
        i2cData[i+1] = getPrintableChar(buffer[i]);
    }
    return i2cData;
}

int MAX6955::write(char command, char data) {
    char i2cData[2];
    i2cData[0] = command;
    i2cData[1] = data;
    int result = i2c_.write(driver_, i2cData, 2);
    wait(0.07);
    return result;
}

int MAX6955::writeS(char* buffer) {
    char* i2cData;
    i2cData = getString(buffer);
    int result = i2c_.write(driver_, i2cData, 9);
    wait(0.07);
    return result;
}

int MAX6955::init(void) {
    int result = 0;
    result = result + write(reg_decodeMode, 0x00);
    result = result + write(reg_scanLimit, 0x07);
    result = result + write(reg_configuration, 0x21);
    result = result + write(reg_globalIntensity, 0x08);
    result = result + write(reg_digitType, 0xFF);
    result = result + write(reg_displayTest, 0x00);
    return result;
}