#include "mbed.h"
#include "USBMouseKeyboard.h"
#include "MMA8451Q.h"
#include "USBSerial.h"
#include <ctype.h>

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define PRESS_ON 0
#define PRESS_OFF 1

MMA8451Q acc(PTE25, PTE24);
//USBMouseKeyboard mouse;
USBSerial serial;

DigitalIn sw1(PTC3);
DigitalIn sw3(PTC12);
int sw1State;
int sw3State;

int main (void)
{
    sw1.mode(PullUp);
    sw3.mode(PullUp);
    char buffer[64];
    
    while (1)
    {
        sw1State=sw1;
        sw3State=sw3;
        
        //int16_t* axis=(int16_t*)malloc(3*sizeof(int16_t));
        //acc.getAccAllAxis(axis);
        //mouse.move(axis[0]/1024,axis[1]/1024);
        
        if(sw1State==PRESS_ON)serial.printf("FRDM USB Serial Port\n");
        //else mouse.release(MOUSE_LEFT);
        
        if(sw3State==PRESS_ON)serial.printf("SW1: %d  SW3: %d\n",sw1State,sw3State);
        //else mouse.release(MOUSE_RIGHT);
        
        if(serial.readable()==1)
        {
            int i;
            serial.scanf("%s",buffer);
            
            for(i=0;i<64;i++)
            {
                if(buffer[i]>=65 && buffer[i]<=90)buffer[i]=tolower(buffer[i]);
                else if(buffer[i]>=97 && buffer[i]<=122)buffer[i]=toupper(buffer[i]);
            }    
            
            serial.printf("Received: %s\n",buffer);
            
            for(i=0;i<64;i++)buffer[i]='\0';
        }
        wait(0.05); //wait 50ms
    }
}

