#include "mbed.h"
#include "USBMouseKeyboard.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define PRESS_ON 0
#define PRESS_OFF 1

MMA8451Q acc(PTE25, PTE24);
USBMouseKeyboard mouse;


DigitalIn sw1(PTC3);
DigitalIn sw3(PTC12);
int sw1State;
int sw3State;

int main (void)
{
    sw1.mode(PullUp);
    sw3.mode(PullUp);
    
    
    while (1)
    {
        sw1State=sw1;
        sw3State=sw3;
        
        int16_t* axis=(int16_t*)malloc(3*sizeof(int16_t));
        acc.getAccAllAxis(axis);
        mouse.move(axis[0]/1024,axis[1]/1024);
        
        if(sw1State==PRESS_ON)mouse.mediaControl(KEY_VOLUME_DOWN);
        //else mouse.release(MOUSE_LEFT);
        
        if(sw3State==PRESS_ON)mouse.mediaControl(KEY_VOLUME_UP);
       
        wait(0.05); //wait 50ms
    }
}