#ifndef SNTPCLIENT_H
#define SNTPCLIENT_H

typedef enum {DST_START, DST_STOP} tDST_START;

typedef struct DST_POINT {
    time_t     t;               // Point in time when DST switch happens (in localtime)
    signed int dst;             // Active DST value (for gSntpDST)
    signed int dstshift;        // DST shift value (regardless if it is active or not)
} tDstPoint;

typedef tDstPoint (*pFncDstCalc)(int tz, int year, tDST_START start);
typedef enum {
#define _(z, fnc, gmt, dst, hr1,wk1,wday1,mon1, hr2,wk2,wday2,mon2) z,
#include "DstZones.h"
    DST_LAST    // LAST ITEM IN ENUM
} tDST_ZONE;


void SNTPSetDstZone(tDST_ZONE zone, bool adjust_clock=false);
const char *SNTPDstZoneName(tDST_ZONE zone);
void SNTPSetRecvTimeout(unsigned int val_s);
void SNTPSetUpdateDelay(unsigned int val_s);
void SNTPSetTimezone(float hours_from_utc, bool adjust_clock=false);
void SNTPSetDST(float hours_from_utc, bool adjust_clock=false);
int  SNTPSetAddresses(const char* server_addresses[], int count, void (*p_free)(void*));
int  SNTPReadIniFile(const char* filename);
void SNTPWriteIniFile(FILE * f);
void   SNTPClientInit(void);
time_t SNTPTime(void);
void   SNTPSetTime(time_t seconds);
time_t SNTPTimeUTC(void);
void   SNTPSetTimeUTC(time_t seconds);
#endif  // SNTPCLIENT_H
//END