// DstZone.h
// Written by iva2k
//
// Data-driven implementation of DST zones.
// This file is included into many places.
// _() macro is defined for each specific use.

// zone is DST symbol
// pFnc is NULL or custom function of pFncDstCalc type
// gmt 0..1
// dst - shift in seconds (typically 3600)
// hr 0..23
// wk 0=last, 1=first, 2=second, etc.
// wday 0=Sunday
// mon 0..11
// _( z, fnc, gmt, dst, hr1,wk1,wday1,mon1, hr2,wk2,wday2,mon2 )
// zone,       pFnc, gmt,dst, 1:hr,wk,wday,mon, 2:hr,wk,wday,mon
//------------------------------------------------------------------------------
_( DST_NONE,   NULL, 0,    0,    0, 0, 0, 0,    0, 0, 0,  0 )
    // USA: 3600; 2, Second SUN, March; 2, First SUN, November
_( DST_USA,    NULL, 0, 3600,    2, 2, 0, 2,    2, 1, 0, 10 )
    // USA: 3600; 2, First SUN, April; 2, Last SUN, October (Pre-2007)
_( DST_USA_06, NULL, 0, 3600,    2, 1, 0, 3,    2, 0, 0,  9 )
    // EU: 3600; 1GMT, Last SUN, March; 1GMT, Last SUN, October
_( DST_EU_GMT, NULL, 1, 3600,    1, 0, 0, 2,    1, 0, 0,  9 )
//    // Just for test
//_( DST_TEST,   NULL, 0, 3600,   18, 1, 2, 0,   12, 1, 4,  0 )

#undef _
//END