#include "mbed.h"
#include "useful.h"

extern int set_baud_rate;

Serial rs232(p13, p14);  // tx, rx
/******************************************/
/*                                        */
/*  Test the RS232 interface              */
/*  Should send and recieve data on the   */
/*  serial port, send a string, and get   */
/*  back what is returned from the RX     */
/*                                        */
/******************************************/
void rs232_opener(void)
{
    rs232.baud(9600);
    rs232.printf("\n\r");
    rs232.printf("MBED Testbed\n\r");
}

int rs232_readable(void)
{
    return(rs232.readable());
}

void rs232_output_string(char *buf)
{
    int a = 0;
    while(a != strlen(buf)){
        rs232.putc(buf[a]);
        if(buf[a]=='\n')
            rs232.putc('\r');
        a++;
    }
}

int rs232_gets(char *s,int len) 
{
    char   c;
    int    cnt=0;

    while ((c = rs232.getc()) != 0) {
        if ((c == 0x0a) || (c==0x0d)) {
            rs232.printf("\n\r");
            *s++ = '\0';
            return(cnt);    /* Return length */
        } else if (c==0x7f) {  /* Delete */
            rs232.putc(0x08);
            rs232.putc(0x20);
            rs232.putc(0x08);
            cnt--;
            *s--;
        } else if (c==0x08) {  /* BS */
            rs232.putc(0x08);
            rs232.putc(0x20);
            rs232.putc(0x08);
            cnt--;
            *s--;
        } else if (c==025) {  /* CTRL-U */
            while (cnt!=0) {
                rs232.putc(0x08);
                rs232.putc(0x20);
                rs232.putc(0x08);
                cnt--;
                *s--;
            }
        } else {
            *s++ = c;
            rs232.putc(c);
            cnt++;
        }
    }
    return(cnt);
}

/******************************************/
/*                                        */
/* Set the baud rate of the serial line   */
/* from the command line input            */
/*                                        */
/******************************************/
#define BAUD_NUMBER 10
void baud_rate(int c, char **a)
{
    int    b,cnt;
    int    v[BAUD_NUMBER] = {300,600,1200,2400,4800,9600,19200,38400,57600,15200};
    
    b = atoi(a[1]);
    cnt = 0;
    while(cnt < BAUD_NUMBER){
        if(v[cnt]==b){    
            rs232.baud(b);
            set_baud_rate = b;
            return;
        }
        cnt++;
    }
    cnt=0;
    lprintf("Select a speed from ");
    while(cnt < BAUD_NUMBER){
        lprintf("%d ",v[cnt]);
        cnt++;
    }
    lprintf("\n\r");
}
/******************************************/
/*                                        */
/* Send a string to the serial port       */
/*                                        */
/******************************************/
void rs232_test_code(int c, char **a)
{
    char    buf[0x100];
    sprintf(buf,"%s\n",a[1]);
    rs232_output_string(buf);
        
}