#include "mbed.h"
#include "main.h"
#include "serial.h"
#include "scripting.h"
#include "local_defines.h"
#include "useful.h"
#include "can.h"
#include "led.h"
#include "network.h"
#include "cmd.h"

/* This file looks after the USB serial code */
Serial pc(USBTX, USBRX); // tx, rx

int sys_state = 0;
int net_state = 0;
int set_baud_rate = 0;
int var[MAX_VAR];
char pwd[0x20];
char station_id = 0;

/* This should act as a 'Hard Crash' catcher to the error lights :-)   */
/* See http://mbed.org/forum/helloworld/topic/624/?page=1#comment-3153 */
extern "C" void HardFault_Handler() { error("Hard Fault!\n"); } 

/* Local Definitions */
#define WELCOME "Diags for the Mbed System"

/* Main Code */
int main() {
    char buf[80];    /* Input Buffer */
    int    r,l = 0;

   sys_state = TO_USB;
   sprintf(pwd,"/local/");      /* set the current directory for the disk functions */
   clear_var();
   exec_profile();
   
   // Start RTC
    time_t seconds = time(NULL);
    if (seconds == (unsigned)-1 || seconds == 0) {
      seconds = 1265904000;     /* http://www.onlineconversion.com/unix_time.htm  */
      set_time(seconds);
      lprintf("RTC initialized, start time %d seconds\r\n", seconds);
    }
   
   sys_state = TO_RS232;
   
   lprintf("\n%s\n\n",WELCOME);
   lprintf("CMD >");
   sys_state = TO_USB;
   lprintf("\n%s\n\n",WELCOME);
   lprintf("CMD >");
    
   can_init(); /* Setup the can bus ready for use */
   
   //   sys_state = TO_RS232;
   sys_state = TO_USB;
   
   while (1) {
        r = 0;
        while(r==0){
            if(pc.readable()){
                sys_state = TO_USB;
                l = usb_gets(buf,sizeof(buf));
                r = 1;
            } else if(rs232_readable()){
                sys_state = TO_RS232;
                l = rs232_gets(buf,sizeof(buf));
                r = 2;
            } 
            can_receive();        /* Check for CAN messages */
            if(net_state){
                network_test();   /* Check the network */
            }
        }
        if(l>2){
            find_cmd(buf);
        }
        
        if (sys_state & TO_USB)
            pc_output_string("\n\rCMD > ");
        if (sys_state & TO_RS232)
            rs232_output_string("\n\rCMD > ");
        sys_state = TO_USB;
    }
}
/* Local Sub Routines */
int usb_gets(char *s,int len) 
{
    char   c;
    int    cnt=0;

    while ((c = pc.getc()) != 0) {
        if ((c == 0x0a) || (c==0x0d)) {
            pc.putc('\n');
            pc.putc('\r');
            *s++ = '\0';
            return(cnt);    /* Return length */
        } else if (c==0x7f) {  /* Delete */
            pc.putc(0x08);
            pc.putc(0x20);
            pc.putc(0x08);
            cnt--;
            *s--;
        } else if (c==0x08) {  /* BS */
            pc.putc(0x08);
            pc.putc(0x20);
            pc.putc(0x08);
            cnt--;
            *s--;
        } else if (c==025) {  /* CTRL-U */
            while (cnt!=0) {
                pc.putc(0x08);
                pc.putc(0x20);
                pc.putc(0x08);
                cnt--;
                *s--;
            }
        } else {
            *s++ = c;
            pc.putc(c);
            cnt++;
        }
    }
    return(cnt);
}

void pc_output_string(char *buf) 
{
    int a = 0;
    while(a != strlen(buf)){
        pc.putc(buf[a]);
        if(buf[a]=='\n')
            pc.putc('\r');
        a++;
    }
}
void exec_profile(void)
{
    char    *a[2] = {"exec","profile.cmd"};
    exec_file(2,a);
}
