#include "mbed.h"
#include "useful.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

/******************************************/
/*                                        */
/*  Simple Diag fr the 4 on board LED's   */
/*                                        */
/******************************************/

void test_leds(char t)
{
    char a;
    
    a = 0;
    while (a!=t){
        led1 = 1;
        wait(0.2);
        led2 = 1;
        wait(0.2);
        led3 = 1;
        wait(0.2);
        led4 = 1;
        wait(0.2);
        led1=0;
        led2=0;
        led3=0;
        led4=0;
        a++;
    }
}

/******************************************/
/*                                        */
/*   Two routines used for debug the      */
/*   code, these let users turn on/off    */
/*   LED's in turn                        */
/*                                        */
/*                                        */
/******************************************/
void led_on(int led)
{
    switch(led){
        case    0    :  /* all on */
            led1 = 1;
            led2 = 1;
            led3 = 1;
            led4 = 1;
            break;
        case    1    :
            led1=1;
            break;
        case    2    :
            led2=1;
            break;
        case    3    :
            led3=1;
            break;
        case    4    :
            led4=1;
            break;
        default      :
            lprintf("Unknown LED Number to turn on %d (Range 0,1,2,3,4)\n",led);
    }
}
void led_off(int led)
{
    switch(led){
        case    0    :  /* all off */
            led1 = 0;
            led2 = 0;
            led3 = 0;
            led4 = 0;
            break;
        case    1    :
            led1=0;
            break;
        case    2    :
            led2=0;
            break;
        case    3    :
            led3=0;
            break;
        case    4    :
            led4=0;
            break;
        default      :
            lprintf("Unknown LED Number to turn off %d (Range 0,1,2,3,4)\n",led);
    }
}
