#include "mbed.h"
#include <stdarg.h>
#include "main.h"
#include "serial.h"
#include "local_defines.h"
#include "useful.h"

extern int var[MAX_VAR];
extern int sys_state;

/* Function: hexview
 *  Prints an array of char to stdout in hex.
 *  The data is grouped in two 8 byte groups per line.
 *  Each byte is displayed as 2 hex digits and every 
 *  line starts with the address of the first byte.
 *
 *  There is no text view of a line.
 *
 * Variables:
 *  buffer - The array to display.
 *  size - The length of buffer.
 * 
 * Author: rmeyer
 */
void hexview(char *buffer, unsigned int size) {
    printf("\n");
    for(int i = 0; i < size; ++i) {
        if((i%16)!=0) {
            printf(" ");
        } else {
            printf("%04X:  ", (i));
        }
        printf("%02hhx", buffer[i]);
        if((i%16) ==  7) { 
            printf(" ");
        }
        if((i%16) == 15) {
            printf("\n\r");
        }
    }
    printf("\n\r\n\r\n\r");
}

/******************************************/
/*                                        */
/* Lprintf, Bring the printf under our    */
/* control, so we can use either rs232    */
/* or the USB-Serial connections as an    */
/* I/O channel.                           */
/*                                        */
/******************************************/

void lprintf(const char* fmt, ...)
{
    char    str[0x1000];
    
    va_list ap;
    va_start(ap, fmt); 
    vsprintf(str, fmt, ap);   
    if (sys_state & TO_RS232){
        rs232_output_string(str);
    } else if (sys_state & TO_USB){
        pc_output_string(str);           
    }
    va_end(ap);
}

/******************************************/
/*                                        */
/* Read a value in from a user, workout   */
/* if its hex or decimal, and return an   */
/* int to the user                        */
/*                                        */
/******************************************/
int htoi(char *str)
{
    if(strlen(str)>=2){
        if(str[0]=='v' || str[0]=='V'){
            return(var[return_var(str)]);
        } else if(str[1]=='x' || str[1]=='X'){
            return(strtol(str, NULL, 16));
        }        
    }
    return(atoi(str));
}

/******************************************/
/*                                        */
/* Given the input string, return the     */
/* number of the variable the user wants  */
/* its added to htoi, so all inputs       */
/* should get access to the variable data */
/*                                        */
/******************************************/

int return_var(char *str)
{
    char    buf[0x4];
    int     a;
    
    buf[0] = str[1];
    buf[1] = str[2];
    buf[2] = str[3];
    buf[3] = str[4];
    a = atoi(buf);
    if(a > MAX_VAR){
        lprintf("In Return_var, var number %d more than MAXVAR %d, returned -1\n",
            a,MAX_VAR);
        return(-1);
    }
    return(a);
}