#include "mbed.h"
#include "local_defines.h"
#include "useful.h"
#include "scripting.h"

extern int var[MAX_VAR];
extern int sys_state;
extern FILE    *exec_fp;

long jmp[MAX_JMP];      /* Jump points */

void clear_var(void)
{
    int a = 0;
    
    while(a != MAX_VAR){
        var[a] = 0;
        a++;
    }
}

void set_var(int c, char **a)
{
    int v,val;
    
    if(sys_state & EXEC_CALLED){
        if(c != 3)
            var_exec_error(VAR_SET_CNT_ERROR);
        else {
            v = return_var(a[1]);
            val = htoi(a[2]);
            var[v]=val;
        }
            
    } else 
        var_exec_error(VAR_EXEC_ERROR);
    
}

void sum_var(int c, char **a)
{   
    int v,val1,val2;
       
    if(sys_state & EXEC_CALLED){
        if(c != 4)
            var_exec_error(VAR_SUM_CNT_ERROR);
        else {
            val1 = htoi(a[1]);
            val2 = htoi(a[3]);
            v = return_var(a[1]);
            switch(a[2][0]){
                case    '+' :
                    var[v] = val1 + val2;
                    break;
                case    '-' :
                    var[v] = val1 - val2;
                    break;
                case    '/' :
                    var[v] = val1 / val2;
                    break;
                case    '*' :
                    var[v] = val1 * val2;
                    break;
                case    '%' :
                    var[v] = val1 * val2;
                    break;
                default     :
                    var_exec_error(VAR_SUM_TYPE_ERROR);
            }
        }
    } else 
        var_exec_error(VAR_EXEC_ERROR);
}
void point_var(int c, char **a)
{
    int v;
    if(sys_state & EXEC_CALLED){
        v = return_jmp(a[1]);
       jmp[v] = ftell(exec_fp);         /* Read the current file pointers position */
       sys_state = sys_state | INDENT_SET;  /* Mark the state as set */
    } else 
        var_exec_error(VAR_EXEC_ERROR);
}
void tst_var(int c, char **a)
{
    int v,val,j;
    int doit=0;
    
    if(sys_state & EXEC_CALLED){
        if(sys_state & INDENT_SET){
            if(c != 5)
                var_exec_error(VAR_TST_CNT_ERROR);
            else {
                v = return_var(a[1]);
                j = return_jmp(a[4]);
                val = htoi(a[3]);
                switch(a[2][0]){
                    case    '<' :
                        if(var[v] < val)
                            doit = 1;
                        break;
                    case    '>' :
                        if(var[v] > val)
                            doit = 1;
                        break;
                    case    '=' :
                        if(var[v] == val)
                            doit = 1;
                        break;
                    case    '!' :
                        if(var[v] != val)
                            doit = 1;
                        break;
                    default     :
                        var_exec_error(VAR_TST_TYPE_ERROR);
                }
                if(doit)
                    fseek (exec_fp ,jmp[j] , SEEK_SET );
            }
        } else
            var_exec_error(VAR_INDENT_ERROR);
    } else 
        var_exec_error(VAR_EXEC_ERROR);
}
void clr_var(int c, char **a)
{
    if(sys_state & EXEC_CALLED){
         clear_var();
    } else 
        var_exec_error(VAR_EXEC_ERROR);
}
void var_exec_error(int state)
{
    switch(state){
        case    VAR_EXEC_ERROR  :
            lprintf("Can only be called from an exec call\n");
            break;
        case    VAR_SET_CNT_ERROR :
            lprintf("Format: set v<num> <value>\n");
            break;
        case    VAR_SUM_CNT_ERROR :
            lprintf("Format: sum v<num> <action> v<num>\n");
            break;
        case    VAR_TST_CNT_ERROR :
            lprintf("Format: tst v<num> <type> <value>\n");
            break;
        case    VAR_INDENT_ERROR :
            lprintf("In branch test, with no point to loop back to\n");
            break;
        case    VAR_SUM_TYPE_ERROR :
            lprintf("Unknown test type should be either +-/*\n");
            break;
        case    VAR_TST_TYPE_ERROR :
            lprintf("Unknown test type should be either <>=!\n");
            break;
        default     :
            lprintf("Unknown exec_error %04x\n",state);
    }
}

int return_jmp(char *str)
{
    char    buf[0x4];
    int     a;
    
    buf[0] = str[1];
    buf[1] = str[2];
    buf[2] = str[3];
    buf[3] = str[4];
    a = atoi(buf);
    if(a > MAX_VAR){
        lprintf("In Return_jmp, jmp number %d more than MAXJMP %d, returned -1\n",
            a,MAX_JMP);
        return(-1);
    }
    return(a);
}