#include "mbed.h"
#include "main.h"
#include "cmd.h"
#include "i2c.h"
#include "serial.h"
#include "scripting.h"
#include "breakup.h"
#include "local_defines.h"

Serial pc(USBTX, USBRX); // tx, rx

int sys_state = 0;
int var[MAX_VAR];

int main() 
{
    char    buf[0x20];    /* input buffer */
    int     r;            /* general int */
    
    sys_state = TO_RS232;
    
    exec_profile();
    
//    relay_operate(0);
//    init_pca9685(0xb8);
//    init_pca9685(0xba);
    
    pc.printf("\n\rDome Controler\n\n\r\r");
    rs232_opener();
    pc.printf("\n\rCMD > ");
    while(1){             /* Command Loop */
        r = 0;
        while(r==0){
            if(pc.readable()){
                sys_state = TO_USB;
                r = usb_gets(buf,sizeof(buf));
            } else if(rs232_readable()){
                sys_state = TO_RS232;
                r = rs232_gets(buf,sizeof(buf));
            }
        }
        if(r>2){
            find_cmd(buf);
        }
        if (sys_state & TO_USB)
            pc_output_string("\n\rCMD > ");
        if (sys_state & TO_RS232)
            rs232_output_string("\n\rCMD > ");
        sys_state = 0;
    }
}

int usb_gets(char *s,int len) 
{
    char   c;
    int    cnt=0;

    while ((c = pc.getc()) != 0) {
        if ((c == 0x0a) || (c==0x0d)) {
            pc.printf("\n\r");
            *s++ = '\0';
            return(cnt);    /* Return length */
        } else if (c==0x7f) {  /* Delete */
            pc.putc(0x08);
            pc.putc(0x20);
            pc.putc(0x08);
            cnt--;
            *s--;
        } else if (c==0x08) {  /* BS */
            pc.putc(0x08);
            pc.putc(0x20);
            pc.putc(0x08);
            cnt--;
            *s--;
        } else if (c==025) {  /* CTRL-U */
            while (cnt!=0) {
                pc.putc(0x08);
                pc.putc(0x20);
                pc.putc(0x08);
                cnt--;
                *s--;
            }
        } else {
            *s++ = c;
            pc.putc(c);
            cnt++;
        }
    }
    return(cnt);
}

void pc_output_string(char *buf)
{
    int a = 0;
    while(a != strlen(buf)){
        pc.putc(buf[a]);
        if(buf[a]=='\n')
            pc.putc('\r');
        a++;
    }
}

void exec_profile(void)
{
    char    *a[2] = {"exec","profile.cmd"};
    exec_file(2,a);
}

