#include <mbed.h>

DigitalOut sortie1(D3); 
DigitalOut sortie2(D4);
DigitalOut sortie3(D5);
DigitalOut led(D13);
DigitalIn  entree1(D9);
DigitalIn  entree2(D10);
DigitalIn  entree3(D11);

Serial pc(USBTX,USBRX);
Serial MP3(D8,D2);

bool setVolume(uint8_t volume);
bool setPlayMode(uint8_t playmode);
bool playSDFile(int fileIndex);
void setup() {

  MP3.baud(9600);
  pc.baud(9600);
  
  setVolume(31); // 0..31 max
  setPlayMode(0);
  wait_ms(2000);
}

int i=0;
int C1=0;
int C2=0;
int C3=0;
int C4=0;
int C5=0;
int C6=0;
int C7=0;
int C8=0;
int C9=0;

int main() {


    while(1) {
    sortie1=1;
        if (entree1==1) {playSDFile(1);}
        if (entree2==1) {playSDFile(4);}
        if (entree3==1) {playSDFile(7);}
    sortie1=0;
    sortie2=1;
        if (entree1==1) {playSDFile(2);}
        if (entree2==1) {playSDFile(5);}
        if (entree3==1) {playSDFile(8);}
     sortie2=0;
     sortie3=1;
        if (entree1==1) {playSDFile(3);}
        if (entree2==1) {playSDFile(6);}
        if (entree3==1) {playSDFile(9);}
     sortie3=0;
  
    
    }
    }



//Set the music index to play, the index is decided by the input sequence
//of the music;
//hbyte: the high byte of the index;
//lbyte: the low byte of the index;
bool playSDFile(int fileIndex)
{

  uint8_t hbyte = fileIndex >> 8;
  uint8_t lbyte = fileIndex & 0B11111111;
  MP3.putc(0x7E);
  MP3.putc(0x04);
  MP3.putc(0xA0);
  MP3.putc(hbyte);
  MP3.putc(lbyte);
  MP3.putc(0x7E);
  wait_ms(10);
  while (MP3.readable())
  {
    if (0xA0 == MP3.getc())
      return true;
    else
      return false;
  }
}
// Pause on/off  the current music
bool pauseOnOff()
{
  MP3.putc(0x7E);
  MP3.putc(0x02);
  MP3.putc(0xA3);
  MP3.putc(0x7E);
  wait_ms(10);
  while (MP3.readable())
  {
    if (0xA3 == MP3.getc())
      return true;
    else
      return false;
  }
}

//Set the volume, the range is 0x00 to 0x1F (0-31)
bool setVolume(uint8_t volume)
{
  MP3.putc(0x7E);
  MP3.putc(0x03);
  MP3.putc(0xA7);
  MP3.putc(volume);
  MP3.putc(0x7E);
  wait_ms(10);
  while (MP3.readable())
  {
    if (0xA7 == MP3.getc())
      return true;
    else
      return false;
  }
}

bool setPlayMode(uint8_t playmode)
{

  //00: single , 01: single loop, 02: all loop, 03: all random
  if (((playmode == 0x00) | (playmode == 0x01) | (playmode == 0x02) | (playmode == 0x03)) == false)
  {
    pc.printf("PlayMode Parameter Error! ");
    return false;
  }
  MP3.putc(0x7E);
  MP3.putc(0x03);
  MP3.putc(0xA9);
  MP3.putc(playmode);
  MP3.putc(0x7E);
  wait_ms(10);
  while (MP3.readable())
  {
    if (0xA9 == MP3.getc())
      return true;
    else
      return false;
  }
}

// stop the current playing music
bool stopFile() {

  MP3.putc(0x7E);
  MP3.putc(0x02);
  MP3.putc(0xA4);
  MP3.putc(0x7E);
  wait_ms(10);
  while (MP3.readable())
  {
    if (0xA4 == MP3.getc())
      return true;
    else
      return false;
  }
}

bool nextFile() {
  MP3.putc(0x7E);
  MP3.putc(0x02);
  MP3.putc(0xA5);
  MP3.putc(0x7E);
  wait_ms(10);
  while (MP3.readable())
  {
    if (0xA5 == MP3.getc())
      return true;
    else
      return false;
  }
}

bool previousFile() {
  MP3.putc(0x7E);
  MP3.putc(0x02);
  MP3.putc(0xA6);
  MP3.putc(0x7E);
  wait_ms(10);
  while (MP3.readable())
  {
    if (0xA6 == MP3.getc())
      return true;
    else
      return false;
  }
}

unsigned char getState() {
  MP3.putc(0x7E);
  MP3.putc(0x02);
  MP3.putc(0xC2);
  MP3.putc(0x7E);
  wait_ms(10);
  while (MP3.readable())
  {
    if (0xC2 == MP3.getc()) // Opcode
      return MP3.getc(); // 01: play, 02:stop, 03:pause
    else
      return 0;
  }

}

unsigned char getSDFileCount() {
  MP3.putc(0x7E);
  MP3.putc(0x02);
  MP3.putc(0xC4);
  MP3.putc(0x7E);
  wait_ms(10);
  while (MP3.readable())
  {
    if (0xC4 == MP3.getc())
      return MP3.getc(); // number of files on sd card
    else
      return 0;
  }
}

unsigned char getFlashFileCount() {
  MP3.putc(0x7E);
  MP3.putc(0x02);
  MP3.putc(0xC4);
  MP3.putc(0x7E);
  wait_ms(10);
  while (MP3.readable())
  {
    if (0xC4 == MP3.getc())
      return MP3.getc(); // number of files on sd card
    else
      return 0;
  }
}

int getCurrentFile() {
  uint8_t hbyte = 0;
  uint8_t lbyte = 0;

  MP3.putc(0x7E);
  MP3.putc(0x02);
  MP3.putc(0xC6);
  MP3.putc(0x7E);
  wait_ms(10);
  while (MP3.readable())
  {

    if (0xC6 == MP3.getc()) {
      hbyte = MP3.getc();
      lbyte = MP3.getc();
      return (hbyte << 8) & lbyte;
    }
    else
      return 0;
  }
}

unsigned char getVolume() {
  MP3.putc(0x7E);
  MP3.putc(0x02);
  MP3.putc(0xC1);
  MP3.putc(0x7E);
  wait_ms(10);
  while (MP3.readable())
  {
    if (0xC1 == MP3.getc())
      return MP3.getc(); // 0 to 31
    else
      return 0;
  }
}










