#include "STEPPER_LED_GUI.h"

DigitalIn CALLIB_BUTTON(USER_BUTTON);

StepperLedGui::StepperLedGui()
{
    lcd.Clear(LCD_COLOR_WHITE);
    ClearLeds();
    uiLedCounter = 0;
    SetLed(0);
    DrawMotor();
}

void StepperLedGui::MotorCallib()
{
    while(ReadDetector() == OFF)
    {
        LedStep(RIGHT);
        wait(STEP_PERIOD);        
    }    
    uiZeroPosition = uiLedCounter;
}

void StepperLedGui::MotorSteps(unsigned int uiStepCount)
{
    for (unsigned int uiStepCounter = 0; uiStepCounter < uiStepCount; uiStepCounter++)
    {
        LedStep(RIGHT);
        wait(STEP_PERIOD);   
    }
}

void StepperLedGui::gotoPosition(unsigned int uiPosition)
{
    eDirection eMovementDirection;
    unsigned int uiRelativePosition;
    uiRelativePosition = uiLedCounter - uiZeroPosition;
    
    if (uiPosition > uiRelativePosition)
    {
        eMovementDirection = RIGHT;
    }
    else if (uiPosition < uiRelativePosition)
    {
        eMovementDirection = LEFT;
    }

    while(uiRelativePosition != uiPosition)
    {
        LedStep(eMovementDirection);
        uiRelativePosition = uiLedCounter - uiZeroPosition;
        wait(STEP_PERIOD);
    }
}

////////////////////////////////private///////////////

tState StepperLedGui::ReadDetector()
{
    if (CALLIB_BUTTON == 1)
        return ON;
    else
        return OFF;
}

void StepperLedGui::DrawLed(unsigned char ucLedNumber)
{
    if (ucLedNumber < LED_COUNT)
        {
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DrawCircle(LED_START_X+LED_DISTANCE*ucLedNumber,LED_Y,LED_RADIUS);
            
            if (eLedStates[ucLedNumber] == ON)
                {
                    lcd.SetTextColor(LCD_COLOR_GREEN);
                }
            else
                {
                    lcd.SetTextColor(LCD_COLOR_WHITE);
                }
            
            lcd.FillCircle(LED_START_X+LED_DISTANCE*ucLedNumber,LED_Y,LED_RADIUS-LED_RIM_WIDTH);
        }
}

void StepperLedGui::SetLed(unsigned char ucLedNumber)
{
    if (ucLedNumber < LED_COUNT)
        {
            ClearLeds();
            eLedStates[ucLedNumber] = ON;
            DrawLed(ucLedNumber);
        }
}

void StepperLedGui::ClearLeds()
{
    for (unsigned char ucLedCounter = 0; ucLedCounter < LED_COUNT; ucLedCounter++)
        {
            eLedStates[ucLedCounter] = OFF;
            DrawLed(ucLedCounter);
        }
}

void StepperLedGui::LedStep(eDirection Direction)
{
    if (Direction == LEFT)
        uiLedCounter = uiLedCounter - 1;
    else if (Direction == RIGHT)
        uiLedCounter = uiLedCounter + 1;
    SetLed(uiLedCounter % LED_COUNT);
    DrawMotor();
}

void StepperLedGui::DrawMotor()
{
    double dAngle = (uiLedCounter%STEPS_PER_REV);
    dAngle = dAngle / STEPS_PER_REV;
    dAngle = dAngle * 2 * PI;
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillCircle(MOTOR_X,MOTOR_Y,MOTOR_RADIUS);
    lcd.SetTextColor(LCD_COLOR_RED);
    lcd.DrawLine(MOTOR_X,MOTOR_Y,MOTOR_X+MOTOR_RADIUS*cos(dAngle), MOTOR_Y+MOTOR_RADIUS*sin(dAngle));
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillCircle(MOTOR_X,MOTOR_Y,MOTOR_SMALL_RADIUS);
    
}
