#ifndef __STEPPER_LED_GUI_H
#define __STEPPER_LED_GUI_H

#include "LCD_DISCO_F429ZI.h"
#include "mbed.h"

#define LED_COUNT 4
#define LED_START_X 30
#define LED_Y 290
#define LED_RADIUS 20
#define LED_DISTANCE 60
#define LED_RIM_WIDTH 1

#define MOTOR_X 120
#define MOTOR_Y 120
#define MOTOR_RADIUS 100
#define MOTOR_SMALL_RADIUS 20
#define STEPS_PER_REV 16

#define PI 3.14159

#define STEP_PERIOD 0.25

typedef enum tState
{
    ON,
    OFF
} tState;

typedef enum eDirection{
    LEFT,
    RIGHT,
    STOP
} eDirection;

class StepperLedGui
{
    public:
        StepperLedGui();
        void MotorCallib();
        void MotorSteps(unsigned int uiStepCount);
        void gotoPosition(unsigned int uiPosition);
    private:
        tState ReadDetector();
        void DrawLed(unsigned char ucLedNumber);
        void SetLed(unsigned char ucLedNumber);
        void ClearLeds();
        void LedStep(eDirection Direction);
        void DrawMotor();
        tState eLedStates[LED_COUNT];
        unsigned int uiLedCounter;
        unsigned int uiZeroPosition;
        LCD_DISCO_F429ZI lcd;
};

#endif