#include "Ledboard.h"

extern LCD_DISCO_F429ZI lcd;

Ledboard::Ledboard(unsigned char ucColumn)
{
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetFont(&Font24);
    lcd.SetBackColor(LCD_COLOR_RED);

    for (unsigned char ucLedCounter = 0; ucLedCounter < LED_COUNT; ucLedCounter++)
    {
        Leds[ucLedCounter] = new Led(ucColumn,ucLedCounter);
    }
}

void Ledboard::On(unsigned char ledNumber)
{
    for (unsigned char ucLedCounter = 0; ucLedCounter < LED_COUNT; ucLedCounter++)
    {
        if(ucLedCounter == ledNumber)
        {
            Leds[ucLedCounter]->On();
        }
        else
        {
            Leds[ucLedCounter]->Off();
        }
    }
}

void Ledboard::Off()
{
    for (unsigned char ucLedCounter = 0; ucLedCounter < LED_COUNT; ucLedCounter++)
    {
        Leds[ucLedCounter]->Off();
    }
}

