#include "Led.h"

extern LCD_DISCO_F429ZI lcd;

Led::Led(unsigned char ucColumnNumber, unsigned char ucRowNumber)
{
    ucColumn = ucColumnNumber;
    ucRow = ucRowNumber;
    
    Redraw(COLOR_DARK);
}

void Led::On()
{
    Redraw(COLOR_LIT);
}


void Led::Off()
{
    Redraw(COLOR_DARK);
}

void Led::Redraw (uint32_t Color)
{
    char cBuffor[3];
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawRect(80*ucColumn,80*ucRow,80,80);
    
    lcd.SetTextColor(Color);
    lcd.FillRect(2+80*ucColumn,2+80*ucRow,77,77);
        
    sprintf(cBuffor, "%d", ucRow);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(1+80*ucColumn,1+80*ucRow,(uint8_t *)&cBuffor, LEFT_MODE);
}
