#include "DECODER.h"
#include "STEPPER_LED_GUI.h"

#define CR '\r'

Serial MyUart(USBTX, USBRX, 9600);
Decoder MyDecoder;
StepperLedGui MyGui;

int puts (char *cBuffer, unsigned char ucBufferSize)
{
    unsigned char ucBufferPointer;
    for (ucBufferPointer = 0; ucBufferPointer <= ucBufferSize; ucBufferPointer++)
    {
        if (cBuffer[ucBufferPointer] == NULL)
            break;
        
    }    
    if (ucBufferPointer == ucBufferSize)
        return 1;
    
    for (unsigned char ucBufferPointer = 0; cBuffer[ucBufferPointer] != NULL; ucBufferPointer++)
    {
        MyUart.putc(cBuffer[ucBufferPointer]);
    } 
    MyUart.putc(CR);
    return 0;
}

int gets (char *cBuffer, unsigned char ucBufferSize)
{
    unsigned char ucBufferPointer = 0;
    
    while(ucBufferPointer < ucBufferSize)
    {
        cBuffer[ucBufferPointer] = MyUart.getc();
        if (cBuffer[ucBufferPointer] == CR)
        {
            cBuffer[ucBufferPointer] = NULL;
            return 0;
        }
        ucBufferPointer++;
    }
    return 1;
}

void handleMessage(Token *pToken)
{
    char cUnknownCommand[] = "unknowncommand";
    char cID[] = "id 0xABCD";
    char cOK[] = "ok";
    
    if (pToken[0].eType == KEYWORD)
        {
        switch(pToken[0].uValue.eKeyword)
        {
        case ID:
            puts(cID, sizeof(cID));
            break;
        case CALLIB:
            MyGui.MotorCallib();
            puts(cOK, sizeof(cOK));
            break;
        case GOTO:
            if (pToken[1].eType == NUMBER)
            {
                MyGui.gotoPosition(pToken[1].uValue.uiNumber);
                puts(cOK, sizeof(cOK));
            }
            else
            {
                puts(cUnknownCommand, sizeof(cUnknownCommand));
            }
            break;
        case STEP:
            if (pToken[1].eType == NUMBER)
            {
                MyGui.MotorSteps(pToken[1].uValue.uiNumber);
                puts(cOK, sizeof(cOK));
            }
            else
            {
                puts(cUnknownCommand, sizeof(cUnknownCommand));
            }
            break;
        default:
            puts(cUnknownCommand, sizeof(cUnknownCommand));
            break;
        }
    }
    else
    {
        puts(cUnknownCommand, sizeof(cUnknownCommand));
    }
}

int main()
{
    char cBuffor[50];
    char cUnknownCommand[] = "unknowncommand";
    
    while(1)
    {
        if (gets(cBuffor,sizeof(cBuffor)) == 0)
        {
            if (MyDecoder.DecodeMsg(cBuffor) == OK)
            {
                handleMessage(MyDecoder.asToken);
            }
            else
            {
                puts(cUnknownCommand, sizeof(cUnknownCommand));
            }
        }
    }
}
