#ifndef DECODER_H
#define DECODER_H

#include "mbed.h"

#define HEX_bm 0x000F
#define MAX_TOKEN_NR 2
#define MAX_KEYWORD_STRING_LTH 6
#define MAX_KEYWORD_NR 4

typedef enum TokeType
{KEYWORD, NUMBER, EMPTY} TokeType;

typedef enum Result
{ OK, ERR } Resul;

typedef enum KeywordCode
{ID, CALLIB, GOTO, STEP} KeywordCode;

typedef union TokenValue
{
enum KeywordCode eKeyword;
unsigned int uiNumber;
char *pcString;
} TokenValue;

typedef struct Token
{
enum TokeType eType;
union TokenValue uValue;
} Token;

typedef struct Keyword
{
enum KeywordCode eCode;
char cString[MAX_KEYWORD_STRING_LTH + 1];
} Keyword;

class Decoder
{
    public:
        enum Result DecodeMsg(char *pcString);
        struct Token asToken[MAX_TOKEN_NR];
    private:
        void ReplaceCharactersInString(char pcString[],char cOldChar,char cNewChar);
        enum Result eHexStringToUInt(char pcStr[],unsigned int *puiValue);
        unsigned char ucFindTokensInString(char *pcString);
        enum Result eStringToKeyword (char pcStr[],enum KeywordCode *peKeywordCode);
        enum Result DecodeTokens();
};

#endif // DECODER_H
