/*this program is written for multicoptor project
 *Developper :lokitsyu azlab
 *mbed.org
 *AC-room
 *mltcptdrv filename:main.cpp
 *using gyro senser ITG-3200
 */

#include "mbed.h"

InterruptIn unit(p8);
I2C i2c(p28,p27);
Ticker timer;


int addr[4]={
    0x20, 0x21, 0x22, 0x23
};//motor driver address

int outval_1, outval_2, outval_3, outval_4;
int outval[4] = {
    outval_1, outval_2, outval_3, outval_4
};//output value


//////////////////////////////////////////////////////////////
//Gyro class
//////////////////////////////////////////////////////////////
class Gyro{
    private:
        int ax_1, ax_2, ax_3, 
            ay_1, ay_2, ay_3, 
            az_1, az_2, az_3;
        float ax, ay, az;        //angr value
        double sum;
    public:
        void get();
        void set();
        void calc();
        double simpson(double,double,double);
};
//get gyro value
void Gyro::get()
{
    int i = 0;
        i2c.start();
    if(i2c.write(11010001)==1){
        i2c.write();
        i2c.start();
        ax_1 = i2c.read();
        i2c.stop();
    }else{
        i2c.stop();
        i = !i;
    }
    if(i == 0){
        ax_1 = ax_1 << 8;
        i2c.start();
        i2c.write(11010001);
        i2c.write();
        i2c.start();
        ax_1 = ax_1 + i2c.read();
        i2c.stop();
    }else{
    }
}

//setting gyro sencer
void Gyro::set()
{
}

void Gyro::calc()
{
}

double Gyro::simpson(double f_0,double f_1,double f_2)
{
    sum += (f_0 + 4 * f_1 + f_2)/6000;
    return sum;
}


///////////////////////////////////////////////////////////////////////
//motor drive control funciton
///////////////////////////////////////////////////////////////////////
void motordrv()
{
    for(int i=0;i<4;i++)
    {
        i2c.start();
        i2c.write(addr[i],outval[i],1);
        i2c.stop();
    }
}

///////////////////////////////////////////////////////////////////////
//main function
///////////////////////////////////////////////////////////////////////
int main() {
    Gyro gyro;
    
    i2c.frequency(400000);
    unit.mode(PullUp);
    unit.fall(&gyro,&Gyro::get);
    timer.attach_us(&motordrv,10000);
    
    gyro.set();
    
    //main loop
    while(1) {
        gyro.calc();
        /*
    
    
         Write Program on This Space
        
    
        */    
    }
}
