//
// LU-3011 11 Digit 7 Segment Display
// v0.1 06/10/11
// Uses ticker to muliplex display to show whole numbers
// Maybe more efficient way to code switch/case segment?
// Doesn't currently handle decimal point - whole numbers only
//

#include "mbed.h"

//Prototypes
void dispNumDig (int num, int digit);
void upDisp (void);
void updateDisp (int num, int digit);
void showNum(unsigned int num);


//Globals
int dispArray[15];          // Holds Displayed Value
int dispArrayIndex = 0;     // Used to cycle digits displayed by ticker

Ticker pov;                 // Ticker Interrupt 
Serial pc(USBTX,USBRX);     // Default PC Comms
DigitalOut myled(LED1);     // Onboard LED for debug

// 7 Segment Display - PCB Connections
// Digits
DigitalOut D11(p7);   //PCB Pin 1   - Digit 11
DigitalOut D10(p30);  //PCB Pin 2
DigitalOut D9(p29);   //PCB Pin 3
DigitalOut D8(p28);   //PCB Pin 4
DigitalOut D7(p26);   //PCB Pin 6
DigitalOut D6(p24);   //PCB Pin 8
DigitalOut D5(p22);   //PCB Pin 10
DigitalOut D4(p20);   //PCB Pin 12
DigitalOut D3(p18);   //PCB Pin 14
DigitalOut D2(p16);   //PCB Pin 16
DigitalOut D1(p14);   //PCB Pin 18

// Segments
DigitalOut SP(p27);   //PCB Pin 5   - Segment Decimal Point
DigitalOut SA(p21);   //PCB Pin 11  - Segment A
DigitalOut SB(p13);   //PCB Pin 19
DigitalOut SC(p25);   //PCB Pin 7
DigitalOut SD(p17);   //PCB Pin 15
DigitalOut SE(p23);   //PCB Pin 9
DigitalOut SF(p15);   //PCB Pin 17
DigitalOut SG(p19);   //PCB Pin 13

////////////////////////////////////////////////

int main()
{
    pov.attach_us(&upDisp, 100); // Function called (upDisp) by ticker(POV), interval (100uS)

    while (1)
    {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
        
        // Quick check - wiring and code correct
        updateDisp (1, 11); //number, digit
        updateDisp (2, 10); //Directly updating array through function
        updateDisp (3, 9);
        updateDisp (4, 8);
        updateDisp (5, 7);
        updateDisp (6, 6);
        updateDisp (7, 5);
        updateDisp (8, 4);
        updateDisp (9, 3);
        updateDisp (0, 2);
        updateDisp (1, 1);
        wait(2);
        
        for(int i=0;i<12;i++)
        {
            dispArray[i] =  11; //Any number other that 0-9 blanks digit
        }
        wait(1);


        while (1)
        {   // Loop Counting
            for (unsigned int i=0; i<2000000000; i++)
            {   //Loop - arbitary value
                showNum(i);     //Update number
                wait_us(50);    //Wait period
            }
        }
        
    }   //End While
}   //End of main

////////////////////////////////////////////////

void showNum(unsigned int num)
{   //Splits number into digits
    if (num < 10)
    {   //If < 10 only 1 digit needed
        updateDisp (num, 1);    //Update array
    }
    else
    {   //Otherwise split and add to array 
        int count = 1;
        while (num!=0)
        {   //Split each digit and add to array in position for display
            int digit = num % 10;
            num = num / 10;
            updateDisp (digit, count);
            count++;
        }
    }
}

////////////////////////////////////////////////

void updateDisp (int num, int digit)
{   //Update display array
    //Seperate function - not needed now but maybe for further fuctionality
    dispArray[digit] =  num;
}

////////////////////////////////////////////////

void upDisp (void)
{   //Called by ticker - switched displayed digit - using POV to muliplex display
    if (dispArrayIndex < 11)
    {   //Increment display index
        dispArrayIndex++;
    }
    else
    {   //Otherwise out of rage - reset
        dispArrayIndex = 0;
    }   
    // Call function to switch digit and value
    dispNumDig (dispArray[dispArrayIndex], dispArrayIndex);
}

////////////////////////////////////////////////

void dispNumDig (int num, int digit)
{   //Switches Digit and corrisponding Segments
//Switch/Case setup - more efficient way of coding???
    switch (digit)
    {
        case 1:
            D1 = 0;
            D2 = 1;
            D3 = 1;
            D4 = 1;
            D5 = 1;
            D6 = 1;
            D7 = 1;
            D8 = 1;
            D9 = 1;
            D10 = 1;
            D11 = 1;
            break;
        case 2:
            D1 = 1;
            D2 = 0;
            D3 = 1;
            D4 = 1;
            D5 = 1;
            D6 = 1;
            D7 = 1;
            D8 = 1;
            D9 = 1;
            D10 = 1;
            D11 = 1;
            break;
        case 3:
            D1 = 1;
            D2 = 1;
            D3 = 0;
            D4 = 1;
            D5 = 1;
            D6 = 1;
            D7 = 1;
            D8 = 1;
            D9 = 1;
            D10 = 1;
            D11 = 1;
            break;
        case 4:
            D1 = 1;
            D2 = 1;
            D3 = 1;
            D4 = 0;
            D5 = 1;
            D6 = 1;
            D7 = 1;
            D8 = 1;
            D9 = 1;
            D10 = 1;
            D11 = 1;
            break;
        case 5:
            D1 = 1;
            D2 = 1;
            D3 = 1;
            D4 = 1;
            D5 = 0;
            D6 = 1;
            D7 = 1;
            D8 = 1;
            D9 = 1;
            D10 = 1;
            D11 = 1;
            break;
        case 6:
            D1 = 1;
            D2 = 1;
            D3 = 1;
            D4 = 1;
            D5 = 1;
            D6 = 0;
            D7 = 1;
            D8 = 1;
            D9 = 1;
            D10 = 1;
            D11 = 1;
            break;
        case 7:
            D1 = 1;
            D2 = 1;
            D3 = 1;
            D4 = 1;
            D5 = 1;
            D6 = 1;
            D7 = 0;
            D8 = 1;
            D9 = 1;
            D10 = 1;
            D11 = 1;
            break;
        case 8:
            D1 = 1;
            D2 = 1;
            D3 = 1;
            D4 = 1;
            D5 = 1;
            D6 = 1;
            D7 = 1;
            D8 = 0;
            D9 = 1;
            D10 = 1;
            D11 = 1;
            break;
        case 9:
            D1 = 1;
            D2 = 1;
            D3 = 1;
            D4 = 1;
            D5 = 1;
            D6 = 1;
            D7 = 1;
            D8 = 1;
            D9 = 0;
            D10 = 1;
            D11 = 1;
            break;
        case 10:
            D1 = 1;
            D2 = 1;
            D3 = 1;
            D4 = 1;
            D5 = 1;
            D6 = 1;
            D7 = 1;
            D8 = 1;
            D9 = 1;
            D10 = 0;
            D11 = 1;
            break;
        case 11:
            D1 = 1;
            D2 = 1;
            D3 = 1;
            D4 = 1;
            D5 = 1;
            D6 = 1;
            D7 = 1;
            D8 = 1;
            D9 = 1;
            D10 = 1;
            D11 = 0;
            break;
        default:    //If out of range switch off all digits
            D1 = 1;
            D2 = 1;
            D3 = 1;
            D4 = 1;
            D5 = 1;
            D6 = 1;
            D7 = 1;
            D8 = 1;
            D9 = 1;
            D10 = 1;
            D11 = 1;
            break;
    }



    switch (num)
    {   //Case not currently included for decimcal point (SP)
        case 0:
            SP = 0;
            SA = 1;
            SB = 1;
            SC = 1;
            SD = 1;
            SE = 1;
            SF = 1;
            SG = 0;
            break;
        case 1:
            SP = 0;
            SA = 0;
            SB = 1;
            SC = 1;
            SD = 0;
            SE = 0;
            SF = 0;
            SG = 0;
            break;
        case 2:
            SP = 0;
            SA = 1;
            SB = 1;
            SC = 0;
            SD = 1;
            SE = 1;
            SF = 0;
            SG = 1;
            break;
        case 3:
            SP = 0;
            SA = 1;
            SB = 1;
            SC = 1;
            SD = 1;
            SE = 0;
            SF = 0;
            SG = 1;
            break;
        case 4:
            SP = 0;
            SA = 0;
            SB = 1;
            SC = 1;
            SD = 0;
            SE = 0;
            SF = 1;
            SG = 1;
            break;
        case 5:
            SP = 0;
            SA = 1;
            SB = 0;
            SC = 1;
            SD = 1;
            SE = 0;
            SF = 1;
            SG = 1;
            break;
        case 6:
            SP = 0;
            SA = 1;
            SB = 0;
            SC = 1;
            SD = 1;
            SE = 1;
            SF = 1;
            SG = 1;
            break;
        case 7:
            SP = 0;
            SA = 1;
            SB = 1;
            SC = 1;
            SD = 0;
            SE = 0;
            SF = 0;
            SG = 0;
            break;
        case 8:
            SP = 0;
            SA = 1;
            SB = 1;
            SC = 1;
            SD = 1;
            SE = 1;
            SF = 1;
            SG = 1;
            break;
        case 9:
            SP = 0;
            SA = 1;
            SB = 1;
            SC = 1;
            SD = 1;
            SE = 0;
            SF = 1;
            SG = 1;
            break;

        default:    // If out of range switch off all segments
            SP = 0;
            SA = 0;
            SB = 0;
            SC = 0;
            SD = 0;
            SE = 0;
            SF = 0;
            SG = 0;
    }
}