#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

// added for GPS Clock
#include "TimeHandler.h"
#include "GPS.h"
#include "TextLCD.h"
//

EthernetNetIf eth;  
HTTPServer svr;

DigitalOut led1(LED1);

// added for GPS Clock
GPS gps(NC, p14);
TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7

// GPS callback function for GGA 
int setup = 300;
void GGA_callback(void){
    GPS_Time gps_t;
    gps.timeNow(&gps_t);

    if(((gps_t.minute == 59) && (gps_t.second == 59))||(setup > 0)){
        if(setup-- == 0) setup = 0;
        struct tm rtc_t;
        rtc_t.tm_year = gps_t.year - 1900;
        rtc_t.tm_mon  = gps_t.month - 1;
        rtc_t.tm_mday = gps_t.day;
        rtc_t.tm_hour = gps_t.hour;
        rtc_t.tm_min  = gps_t.minute;
        rtc_t.tm_sec  = gps_t.second;
        set_time(mktime(&rtc_t));
        printf("%04d/%02d/%02d %02d:%02d:%02d\r\n", 
        gps_t.year, gps_t.month, gps_t.day, gps_t.hour, gps_t.minute, gps_t.second );
    }
    time_t now = time(0) + TIME_OFFSET;
    struct tm *t = localtime(&now);
    lcd.locate(0, 0);
    lcd.printf("%04d/%02d/%02d\n%02d:%02d:%02d", 
        t->tm_year + 1900, t->tm_mon + 1, t->tm_mday, t->tm_hour, t->tm_min, t->tm_sec );
    }
//

int main() {
  lcd.cls();
  lcd.printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    lcd.printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  lcd.printf("Setup OK\n");
  
  svr.addHandler<SimpleHandler>("/"); //Default handler
// added for GPS Clock
  svr.addHandler<TimeHandler>("/time"); //added
//
  svr.bind(80);
  
  lcd.printf("Listening...\n");

// GPS module setup
  gps.baud(9600);
  gps.format(8, GPS::None, 1);
  gps.attach_gga(&GGA_callback);
  lcd.cls();
//

  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      tm.start();
    }
  }
}
