//Bibliotheken
#include "mbed.h"
#include "EthernetInterface.h" 

//Seriele communicatie
Serial pc(USBTX, USBRX); //seriële communicatie opstarten op pinnen USBTX en USBRX, deze kan worden gelezen aan de hand van bv putty

//Timer
Ticker ticker;  //declaratie van de ticker, gebruikt voor sampling
volatile int timer_flag = 0;  //vlag die wordt geset en gereset bij elk timer-event

//UDP en ethernet
const char* A_ADDRESS = "192.168.1.1";      //ip adres van de K64F instellen (voor UDP socket)
const int A_PORT = 1000;    //poort van K64F setten, wordt meegestuurd in UDP header
const char* B_ADDRESS = "192.168.1.101";    //ip adres van de bestemming, moet op bestemming juist worden geconfigureerd zodat het overeenstemt met dit adres
const int B_PORT = 2221;    //poortnummer van het adres waarover zal worden gecommuniceerd, moet op bestemming (in Node-RED) worden geconfigureerd om naar deze poort te luisteren

float getal= 0.000; 

//Accelerometer
AnalogIn  inX(A5);      //x-as van accelerometer is fysiek verbonden met pin A5 van K64F
AnalogIn  inY(A4);      //y-as van accelerometer is fysiek verbonden met pin A4 van K64F
AnalogIn  inZ(A3);      //z-as van accelerometer is fysiek verbonden met pin A3 van K64F
float staticX;      //deze variabele bevat de waarde van de x-as bij initialisatie/reset van de accelerometer
float staticY;      //deze variabele bevat de waarde van de y-as bij initialisatie/reset van de accelerometer
float staticZ;      //deze variabele bevat de waarde van de z-as bij initialisatie/reset van de accelerometer

//Functie declaraties
void timer_isr();   //deze functie zal worden opgeroepen bij elk timer-event

int main() {    
    //SETUP---------------------------------------------------------------------
    pc.printf("start microcontroller"); //stuurt bericht naar pc dat het programma is gestart
    ticker.attach(&timer_isr,0.0003125);    //initialiseert een ticker, dat om de 0.0003125s de functie timer_isr zal uitvoeren
    
    EthernetInterface eth;  //de ethernetinterface die verantwoordelijk is voor de communicatie via de ethernetpoort van de k64f
    eth.init(); //    initialiseren van de interface
    pc.printf("IP : %s\n", eth.getIPAddress()); //gateway ip-adres uitprinten van de ethernetinterface
    if (eth.connect() < 0) {    //als de connectie niet is gelukt, een error uitprinten naar pc
        pc.printf("Failed to connect\n\r");
        return -1;
    }
    
    while(eth.connect() < 0) {
        eth.init();    
    }
    
    UDPSocket sockA;    //een UDP socket initialiseren
    if (sockA.bind(A_PORT) < 0) {   //een poort geven aan de socket, als dit faalt, een error uitprinten
        pc.printf("Failed to bind UDP Socket to PORT : %d\n\r", A_PORT);
        return -1;
    }
    else pc.printf("Bind UDP Socket to PORT : %d\n\r", B_PORT);     //poort van bestemming uitprinten
    
    sockA.set_blocking(false);  //socket op non-blocking mode zetten
    
    //Endpoint EndpointA;     //adress en poortnummer toekennen aan endpoint a
    //EndpointA.set_address(A_ADDRESS, A_PORT);    
    Endpoint EndpointB; //adress en poortnummer toekennen aan endpoint b
    EndpointB.set_address(B_ADDRESS, B_PORT);
    
    staticX = inX; 
    staticY= inY;
    staticZ = inZ;
    //--------------------------------------------------------------------------
    //EINDE SETUP
    //MAIN LOOP-----------------------------------------------------------------
    while(1) { 
        if (timer_flag) {
            timer_flag = 0;
            float x = (inX-staticX)*3300/330;   //inX-staticX zorgt dat data bij stilstand rond 0 ligt (statische positie wegwerken)
            float y = (inY-staticY)*3300/330;   //schaalfactor 3300/330: *3300 om het signaal naar mV om te zetten, /330 om naar g om te zetten 
            float z = (inZ-staticZ)*3300/330;
        char u_packet[20];  //initialiseren van een datapakket dat 3 floats moet bevatten
        sprintf(u_packet, "%.3f,%.3f,%.3f \r",x, y, z); //3 floats, afgerond op 3 cijfers na de komma als string in u_packet steken
        int n_send=sockA.sendTo(EndpointB, (char*)u_packet, sizeof(u_packet));   //u_packet verzenden via sockA naar endpointB     
        } 
    } 
    //--------------------------------------------------------------------------
    //EINDE MAIN LOOP-----------------------------------------------------------
    
    sockA.close(false);
    eth.disconnect(); 
    return 0;
}
void timer_isr()
{
    timer_flag = 1;   //vlag setten
}