#include "mbed.h"

I2C i2c(I2C_SDA, I2C_SCL); //initialiseer i2c met pinnen I2C_SDA en I2C_SCL
SPI spi(D11, D12, D13); //initialiseer spi met pinnen d11,d12 en d13 (miso mosi en clk)
DigitalOut cs(D0); //chipselect van SPI op D0 zetten

const int adres = 0x48; //adres setten, hier een dummy adres want adres van audio codec board is niet gekend

int main() {
    cs =1; //chips deselecteren
    char data[2];   //dummy data    
    data[0]=1;      //dummy data
    data[1]=2;      //dummy data
    int spi_data = 10;
    
    spi.format(8,3); //8 bit data en mode 3
    spi.frequency(1000000); //1 MHz frequentie
    
    cs=0; //chip select low => apparaat selecteren
    spi.write(spi.data); 
    
    i2c.write(adres, data, 2);  //dummy data met lengte 2 naar adres sturen
    
    i2c.read(adres, data, 2)    //dummy data inlezen
}
    
    