//==================================
//    The Nucleo Distance Calculator
//        v. 1.0
//==================================
//    by Lorenzo Arrigoni 
//    laelectronics@libero.it
//----------------------------------
//     November 2015
////////////////////////////////////////////
// This is a simple that measures the distance
// and signals in video and with a buzzer if
// the measured distance is below a certain threshold.
//////////////////////////////////////////

#include "mbed.h"
#include "HCSR04.h"
#include "NOKIA_5110.h" 


DigitalOut buzzer(D7) ;
HCSR04 ultra(D3,D4);   //pin trigger, pin echo

//treshold for buzzer
#define treshold 5 // cm

int start_position =0.5 ;
int current_position = start_position ;

// swith on/off for bluetooth
#define BLUE 0

// debug mode
#define DEBUG 1

#if DEBUG == 0
//#define PC_DEBUG(args...) pc.printf(args)
#else
//#define PC_DEBUG(args...)
#endif

#if BLUE == 1
Serial pc(D8,D2);
#else
Serial pc(USBTX, USBRX);
#endif




float range=0;
//char gg ;

void blink_buzz(DigitalOut name, float time)
{
   name = 1 ;
   wait_ms(time); 
   name = 0 ; 
}

int main() {
    
    // initialize 
    buzzer = 0 ; 
    
    LcdPins myPins;
    myPins.sce  = D8;
    myPins.rst  = D9;
    myPins.dc   = D10;
    myPins.mosi = D11;      //SPI_MOSI;
    myPins.miso = NC;
    myPins.sclk = D13;      //SPI_SCK;
    NokiaLcd myLcd( myPins );
    
     
    /// LCD initialization
    myLcd.InitLcd();        // LCD init
    myLcd.DrawString("Loarri - 2015");
    myLcd.SetXY(0,2); 
    myLcd.DrawString("LCD set up complete");
    myLcd.SetXY(0,2);    
    wait(2);
    myLcd.ClearLcdMem();
    /// end LCD initialization
    
    
    //pc.printf("Program Start\n\r");    
    myLcd.DrawString("Program Start");
    wait(1);
    myLcd.ClearLcdMem();
    //myservo = start_position ;  //set servo at 0 degree
    current_position = start_position ;
    while(1) {
        //myLcd.ClearLcdMem();
        ultra.startMeas();
        
        wait(0.2);
        
        
        if( ultra.getMeas(range) == RANGE_MEAS_VALID)
        {
            pc.printf("Range -> %f cm\n\r",  range);
            myLcd.SetXY(0,1);
            myLcd.DrawString("Range -> ");
            myLcd.SetXY(0,2);
            int i=(int)range;
             pc.printf("valore di i -> %i cm\n\r",  i);
            char gg[4] ; 
            sprintf(gg, "%f", range);
            pc.printf("valore di gg -> %c cm\n\r",  gg);
            //gg = NokiaLcd::NumToStr(range) ;
            myLcd.DrawString(gg);
            myLcd.SetXY(0,3);
            myLcd.DrawString(" cm");
            if (range < treshold ) {
                blink_buzz(buzzer,10);
                myLcd.ClearLcdMem();
                myLcd.SetXY(0,1);
                myLcd.DrawString("Soglia superata.");
                wait(1);
                myLcd.ClearLcdMem();
                }
        }
    }
}
