/*
--------------------
DS1302_test_with_STM32_and_LCD16x2

Author: L. Arrigoni
June 2021
--------------------

Simple test with RTC module driven by a STM32F411RE Nucleo board
with 16x2 HD44780 LCD.
DS1302 powered by 3.3 V without pull up resistor on I2C lines
with callback.
I2C line for LCD needs 2 pullup resitors 2.2K on SDA e SCL
D3 (SDA) ,D6 (SCL)

Note: to reset/set the starting date supply the DS1302 with 5V


*/


#define SCLK    D15
#define IO      D14
#define CE      D8

//Comment this line if the DS1302 is already running
//#define INITIAL_RUN

#include "mbed.h"
#include "DS1302.h"
#include "TextLCD.h"


DS1302 clk(SCLK, IO, CE);
// Set LCD
I2C i2c_lcd(D3 ,D6); // SDA, SCL
// LCD instantiation 
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2);      

int main() {
    lcd.setBacklight(TextLCD::LightOn);
    lcd.printf("Date&Time \nby L. Arrigoni");
    wait(3);
    lcd.cls();

    #ifdef INITIAL_RUN
    //clk.set_time(1256729737);
    clk.set_time(1623792610);  //from https://www.unixtimestamp.com/
    #endif
    
    char storedByte = clk.recallByte(0);
    printf("\r\nStored byte was %d, now increasing by one\r\n", storedByte);
    clk.storeByte(0, storedByte + 1);
    char buffer[32],timebuf_dMyy[14];
    while(1) {
        time_t seconds = clk.time(NULL);
        printf("Date and time: %s\r", ctime(&seconds));
        strftime(buffer, 32, "%I:%M:%S %p\n", localtime(&seconds));
        strftime(timebuf_dMyy, 14, "%d-%b-%Y", localtime(&seconds));
        lcd.locate(0,0);
        lcd.printf("Date:%s",timebuf_dMyy);
        lcd.locate(0,1);
        lcd.printf("Time:%s", buffer);
        wait(1);
    }
}


