/*
--------------------
Author: L. Arrigoni
May 2021
--------------------

Simple test with RTC module and STM32F411RE Nucleo board.
DS1302 powered by 3.3 V without pull up resistor on I2C lines

*/


#define SCLK    D15
#define IO      D14
#define CE      D8

//Comment this line if the DS1302 is already running
//#define INITIAL_RUN

#include "mbed.h"
#include "DS1302.h"

DS1302 clk(SCLK, IO, CE);

int main() {
    #ifdef INITIAL_RUN
    //clk.set_time(1256729737);
    clk.set_time(1623257900);  //from https://www.unixtimestamp.com/
    #endif
    
    char storedByte = clk.recallByte(0);
    printf("\r\nStored byte was %d, now increasing by one\r\n", storedByte);
    clk.storeByte(0, storedByte + 1);
    
    while(1) {
        time_t seconds = clk.time(NULL);
        printf("Date and time: %s\r", ctime(&seconds));
        wait(1);
    }
}


