#include "mbed.h"

/* Simple test for SOMO-14D module.
 Plays a selected file. See www.4dsystems .com.au for details.
 
 Author: Lluis Nadal.
 Date: October 10th 2010.

 File names must match file number in decimal:  0000.ad4 ... to 0511.ad4
 Commands:
    File addres (fileNumber): 0x0000 - 0x01FF
    Play/Pause: 0xFFFE
    Volume (8 levels): 0xFFF0 - 0xFFF7
    Stop: 0xFFFF

*/

DigitalOut reset(p16); // connected to SOMO p10
DigitalIn busy(p15);   // connected to SOMO p5

// SOMO p9 connected to ground
// SOMO p8 connected to Vcc = +3.3V
// SOMO p11, p12 connected to speaker
DigitalOut data(p5);     // connected to SOMO p4
DigitalOut clk(p7);      // connected to SOMO p3
unsigned short fileNumber;
unsigned short command;


void init() {

    clk = 1;
    reset = 1;
    reset = 0;
    wait(0.005);
    reset = 1;
    wait(0.3);
}



void writeData(unsigned short value) {

    clk = 0;
    wait(0.002);
    for (int i = 0; i<16; i++) {
        wait(0.000100f);
        data = value & 0x8000; // selects most significant bit
        wait(0.000001f);
        clk = 1;
        wait(0.000050f);
        clk=0;
        value = value <<1;     // shifts one bit left
    }
    clk =1;
    wait(0.002);
}


int main() {
    wait(0.5);
    while (busy == 1); // checks if SOMO is busy

    fileNumber = 0x0001; //selects 2nd file
    command = 0xFFFE;    // play file command

    init();

    writeData(fileNumber);
    writeData(command);

}
