#include "mbed.h"

/*
***************************************************************************
MCP9800_Test. 9-12 bit temperature sensor and thermostat.
2.7-5.5 V. 4.7kOhm pull-up resistors at SDA and SCLK.

This program sets 12 bit ambient temperature readings resolution.

Pointer bits:
00: temperature register. 01: configuration register.
10: temperature hysteresis register. 11: temperature limit-set register.
Author: Lluis Nadal. August 2011.
***************************************************************************
*/

I2C i2c(p9, p10); // SDA, SCL
Serial pc(USBTX, USBRX);

const int addr_R = 0x91; // Address to read
const int addr_W = 0x90; // Address to write
//const int addr_R = 0x9B ; // Address to read
//const int addr_W = 0x9A; // Address to write

char data[3];
char TL[2];
char TLR[2];
char TH[2];
char CR[1];
int t;
float temp;


void read_temp() {

    int sign;
    i2c.start();
    i2c.write(addr_W);//Address to write pointer
    i2c.write(0x00);// Write pointer to ambient temperature register
    i2c.read(addr_R, data, 2);
    i2c.stop();

    //pc.printf("Temperature register: (%d, %d)\r\n",data[0], data[1]);
    sign = data[0]>>7;
    //pc.printf("Sign: %d \r\n",sign);

    if (sign == 1) { // If number is negative
        data[0] = ~data[0]; // Inverts (compliments)the bits
        data[1] = ~data[1]; // Inverts (compliments)the bits
        t = data[0];
        t = -((t<<4) | (data[1]>>4)+1);// Packs and adds one to convert to negative integer
        temp = t/16.0;
    }

    else {
        t = data[0];
        t = ((t<<4) | (data[1]>>4));
        temp = t/16.0;
    }
    pc.printf("Temperature: %.4f C\r\n",temp);
    pc.printf("\r\n");
}


void read_TL() {      // Read temperature limit register

    i2c.start();
    i2c.write(addr_W);//Address to write pointer
    i2c.write(0x03);// Write pointer to TL register
    i2c.read(addr_R, TLR, 2);
    i2c.stop();
    pc.printf("Temperature limit register: (%d, %d)\r\n",TLR[0], TLR[1]);
    pc.printf("\r\n");
}

void read_TH() {     // Read hysteresis register

    i2c.start();
    i2c.write(addr_W);//Address to write pointer
    i2c.write(0x02);// Write pointer to TH register
    i2c.read(addr_R, TH, 2);
    i2c.stop();

    pc.printf("Temperature hysteresis register: (%d, %d)\r\n",TH[0], TH[1]);
    pc.printf("\r\n");
}


void read_CR() {        // Read configuration register

    i2c.start();
    i2c.write(addr_W);//Address to write pointer
    i2c.write(0x01);// Write pointer to configuration register
    i2c.read(addr_R, CR, 1);
    i2c.stop();

    pc.printf("Configuration register: (%d)\r\n",CR[0]);
    pc.printf("\r\n");
}

// Set temperature limit (9-bit)
void set_TL(float n) {  // -25.4375, 25.4375, 125, -55...
    char msb;
    char lsb;
    if (n < 0) {
        t = (int)(-n*16.0-1);
        pc.printf("t = %d\r\n", t);
        t = t<<4;
        lsb = t & 0xFF;
        msb = t>>8;
        lsb = ~lsb; //Inverts (compliments)the bits
        msb = ~msb; //Inverts (compliments)the bits
//pc.printf("(%d, %d)\r\b", msb, lsb);
    } else {
        t = (int)(n*16.0);
        t = t<<4;
        lsb = t & 0xFF;
        msb = t>>8;
//pc.printf("(%d, %d)\r\b", msb, lsb);
    }
    i2c.start();
    i2c.write(addr_W);//Address to write pointer
    i2c.write(0x03);// Write pointer to temperature-limit register
    i2c.write(msb);// Write data
    i2c.write(lsb);// Write data
    i2c.stop();
}

// Set hysteresis register (9-bit)
void set_TH(float n) {  // -25.4375, 25.4375, 125, -55...
    char msb;
    char lsb;
    if (n < 0) {
        t = (int)(-n*16.0-1);
        pc.printf("t = %d\r\n", t);
        t = t<<4;
        lsb = t & 0xFF;
        msb = t>>8;
        lsb = ~lsb; //Inverts (compliments)the bits
        msb = ~msb; //Inverts (compliments)the bits
//pc.printf("(%d, %d)\r\b", msb, lsb);
    } else {
        t = (int)(n*16.0);
        t = t<<4;
        lsb = t & 0xFF;
        msb = t>>8;
//pc.printf("(%d, %d)\r\b", msb, lsb);
    }
    i2c.start();
    i2c.write(addr_W);//Address to write pointer
    i2c.write(0x02);// Write pointer to hysteresis register
    i2c.write(msb);// Write data
    i2c.write(lsb);// Write data
    i2c.stop();
}





int main() {

    i2c.frequency(200000); // Max 400000 Hz

    pc.printf("Initial readings: \r\n");
    pc.printf("\r\n");
    read_TL(); // Read temperature limit register
    read_TH(); // Read hysteresis register
    read_CR(); // Read configuration register

    // Set 12 bit resolution
    i2c.start();
    i2c.write(addr_W);//Address to write pointer
    i2c.write(0x01);// Write pointer to configuration register
    i2c.write(0x60);// Write data
    i2c.stop();

    // Set temperature limit (9-bit)
    set_TL(25.4375);   // -25.4375, 25.4375, 125, -55...
// If ambient temperature > temperature limit then alert pin is low (with a pull-up resistor).


    // Set hysteresis register (9-bit)
    set_TH(24.4375);   // -25.4375, 25.4375, 125, -55...

    wait(1);

    pc.printf("\r\n");
    pc.printf("Readings after changes: \r\n");
    pc.printf("\r\n");
    read_TL();       // Read temperature limit register
    read_TH();       // Read hysteresis register
    read_CR();       // Read configuration register
    read_temp();     // Read ambient temperature
    pc.printf("\r\n");

}
