#include "mbed.h"

/*
***************************************************************************************
MCP4725_Test. 12-bit DAC with i2C interface.
pin 3(Vdd)= 3.3V. pin 6(A0) = 0. pin 4(SDA) and pin 5(SCL): 4,7k pull-up resistors.
Attach multimeter to pin1(Vout) and ground.
Author: Lluis Nadal. August 2011.
***************************************************************************************
*/

I2C i2c(p9, p10); // SDA, SCL
Serial pc(USBTX, USBRX);

const int addr_R = 0xC1; // Address to read
const int addr_W = 0xC0; // Address to write

void write(float v) { // 0 < v < 3.3 V
    char H;      // High byte
    char L;      // Low byte
    int n;
    n = (int)(v*4096/3.3);
    pc.printf(" n= %d\r\n", n);
    H = n>>4;
    L = (n<<4 & 0xF0);
    pc.printf(" (H, L)=(%d, %d)\r\n", H, L);
    pc.printf("\r\n");
    i2c.start();
    i2c.write(addr_W); // Write address to write
    i2c.write(0x40);   // Write command
    i2c.write(H);      // Write high byte
    i2c.write(L);      // Write low byte
    i2c.stop();
}

void write_fast(float v) {
    char H=0;
    char L=0;
    int n;
    n = (int)(v*4096/3.3);
    pc.printf(" n= %d\r\n", n);
    L = n & 0xFF;
    H = (n>>8) & 0x0F;
    pc.printf(" (H, L)=(%d, %d)\r\n", H, L);
    pc.printf("\r\n");
    i2c.start();
    i2c.write(addr_W);
    i2c.write(H);
    i2c.write(L);
    i2c.stop();
}

void write_EEPROM(float v) { // 0 < v < 3.3 V
    char H;      // High byte
    char L;      // Low byte
    int n;
    n = (int)(v*4096/3.3);
    pc.printf(" n= %d\r\n", n);
    H = n>>4;
    L = (n<<4 & 0xF0);
    pc.printf(" (H, L)=(%d, %d)\r\n", H, L);
    pc.printf("\r\n");
    i2c.start();
    i2c.write(addr_W); // Write address to write
    i2c.write(0x60);   // Write command
    i2c.write(H);      // Write high byte
    i2c.write(L);      // Write low byte
    i2c.stop();
}


int main() {

    i2c.frequency(100000);

    // On power-up the voltage is the data stored in EEPROM.
    pc.printf(" On power-up the voltage is the data stored in EEPROM.\r\n");
    pc.printf("\r\n");
    wait(5);

    // Write to DAC register in normal mode
    pc.printf(" Normal mode\r\n");
    write(1.3585);
    wait(5);
    write(2.6758);
    wait(5);
    write(1.7554);
    wait(5);

    // Write to DAC register in fast mode
    pc.printf(" Fast mode\r\n");
    write_fast(1.3585);
    wait(5);
    write_fast(2.6758);
    wait(5);
    write_fast(1.7554);

    // Write to EEPROM
    pc.printf(" Write to EEPROM\r\n");
    write_EEPROM(0.5); // On power_up the voltage will be 0.5V.


}