#include "mbed.h"

// MCP4141. 2.7 to 5.5V 7-bit linear digital potentiometer with SPI interface.
// Wiper commands can be write or read. This program is to write commands only.
// MOSI/MISO are multiplexed in the MCP4141 side.

// Author: Lluis Nadal. August 2011.


DigitalOut leds[] = {(LED1), (LED2),(LED3),(LED4)};

//Define SPI mBed side:
SPI spi(p5, p6, p7); // mosi, miso, sclk. To write commands only, you do not need to connect p6(miso) to MCP4141.
DigitalOut cs(p8); // Chip select. Active low.

/*
MCP4141 side:
p8 = Vdd: +3.3V. p4 = Vss: GROUND. p1: cs (mBed's p8).
p2: sclk (mBed's p7). p3: SDI (mBed's p5). p5: potentiometer a. p7: potentiometer b.
Rab: 5k, 10k 50k or 100k options. p6: wiper (75 Ohm).
Attach ohmeter to pins p6 and p7.
*/

void write(int n) { // 0 >= n <= 128
    cs=1;
    cs=0;
    spi.write(0x00); // Address(volatile) 0000, write=00, data=00 = 0x00
    spi.write(n); // Data 
    cs=1;
}

void increment() {
    cs=1;
    cs=0;
    spi.write(0x07);// Address(volatile) 0000, increment 0100 = 0x07
    cs=1;
}

void decrement() {
    cs=0;
    spi.write(0x0B);// Address(volatile) 0000, decrement 1000 = 0x0B
    cs=1;
}



int main() {

    cs=1; // Disables MCP4141

    spi.format(8,0); // 8 bits , mode 0
    spi.frequency(1000000); // Default SPI frequency. ( 250kHz maximum for read commands).

    while (1) {

        leds[0]=0;
        leds[1]=0;
        leds[2]=0;
        leds[3]=0; // All leds off.
        wait(1);
        
        write(32);// Set wiper to 32/128 = 1/4 Rab
        leds[0]=1;
        wait(4);

        write(64);// Set wiper to 64/128 = 1/2 Rab
        leds[1]=1;
        wait(4);

        write(96);// Set wiper to 96/128 = 3/4 Rab
        leds[2]=1;
        wait(4);

        // Decrement wiper 10 times
        for (int i=0; i<10; i++) {
            decrement();
        }
        leds[3]=1;
        wait(4);

        // Increment wiper 10 times
        for (int i=0; i<10; i++) {
            increment();
        }

        leds[3]=0;
        wait(4);

    }

}
