
/*
****************************************************************************************************
Wireless temperature transmitter with ER400TRS wireless transceiver and MCP9700 temperature sensor.
433 MHz transceiver.  180 bytes of data. 19200 Baud.
MCP9700 temperature sensor: -40ºC - +125ºC.

Wiring MCP9700:
p1: +3V3. p2(Vout): mBed's p15. p3: ground.

Wiring ER400TRS:
p1: antenna(17 cm). p2,p7(Host Ready Input) and p9: ground.
p6(Serial Data In): mBed's p9(tx). p8: Vcc = +5 V.

Author: Lluis Nadal. August 2011.
*****************************************************************************************************
*/

#include "mbed.h"
//#include "TextLCD.h" . Optional

// LCD optional
// Define LCD connections.
//TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4, d5, d6, d7

Serial pc(USBTX, USBRX); // tx, rx
Serial transmitter(p9, p10);  // tx, rx
AnalogIn temp(p15);

char s1[10];
char s2[10];
float T;


float tempRead() {

    float Ta = 0.0;
    float t = temp.read();           // read the analog data
    Ta = ((t * 3.3) - 0.5)/ 0.01;

    return Ta;                      // return the temp
}


int main() {

    //lcd.cls();
    pc.printf("Init: 19200 Baud\r\n\r\n");
    //lcd.printf("Init: 19200 Baud");
    wait(2);
    transmitter.baud(19200);

    while (1) {
        T = tempRead();
        sprintf(s1, "%.1f", T);
        sprintf(s2, "%.1f\n", T); //scanf in the receiver needs a whitespace or newline character
        transmitter.printf(s2);
        //lcd.cls();
        sprintf(s1,"%s C", s1);
        pc.printf(" %s\r\n", s1);
        //lcd.printf(s1);

        wait(2);
    }
}