#include "mbed.h"
#include "NTPClient.h"
#include "EthernetInterface.h"
  
int main() {

  EthernetInterface eth;

  printf("Setting up...\n");
  
  int ethError = eth.connect();
    
  if(ethError == 0)
  {
    NTPClient ntp(eth);
    printf("ETH is up : %s\n", eth.get_ip_address());
    time_t ctTime;
    ctTime = time(NULL);  
    printf("Current time is (UTC): %s\n", ctime(&ctTime));  

    ntp.setTime("0.uk.pool.ntp.org");
    
    ctTime = time(NULL);  
    printf("\nTime is now (UTC): %s\n", ctime(&ctTime)); 
  
    eth.disconnect();
  } else {
      printf("Connect failed (%d)", ethError);
  }
  
  return 0;
  
}
