#include "mbed.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
Serial pc(USBTX, USBRX);
int main(void)
{
    pc.baud(9600);
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED_RED);
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);

    while (true) {
        pc.printf("X= %g \n\r",acc.getAccX());
        rled = 1.0 - abs(acc.getAccX());

        pc.printf("Y= %g \n\r",acc.getAccY());
        gled = 1.0 - abs(acc.getAccY());

        pc.printf("Z= %g \n\n\r",acc.getAccZ());
        bled = 1.0 - abs(acc.getAccZ());
        wait(1);
        
    }
}
