#include "mbed.h"
#include "TextLCD.h" //Librería del LCD
#include "QEI.h"  //Librería del encoder
#include "ds3231.h" // Librería del módulo 
#include <string>
 
DigitalOut myled(LED1); //Led LD3 de la tarjeta
TextLCD lcd(PF_1, PA_9, PA_11, PA_12, PB_1, PA_0);// Declaración de los puertos
QEI encoder (PA_1, PB_3, NC, 624); // (DT, Clk)
DigitalIn mybuttonE(PA_3); //Cambia posicion del numero de la placa (Encoder-SW) 
DigitalIn mybutton(PA_4); //Termina y consolida valores de la placa y sale del loop (Pulsador)
Ds3231 rtc(PB_7, PB_6); //rtc object Ds3231::Ds3231(PinName sda, PinName scl) : I2C(sda, scl)

ds3231_alrm_t alarm ; 
uint16_t rtn_val;
int year,month,date,hours,minutes,seconds; //Mejor manejo de las variables.
int cambio=0, diferencia=0; //Para mover la placa del auto.

void imprimir(int pos, int linea, const char * datoParaMostrar, bool limpiar)
    {
        if (limpiar)
            {
                lcd.cls();
            }
        lcd.locate(pos,linea);
        lcd.printf(datoParaMostrar);
    }

void Saludo()
    {
        imprimir(0,0,"  Alarma Para",true);
        imprimir(0,1,"  Pico y Placa",false);
        wait(4);
        lcd.cls(); 
    }
    
void MostrarFecha()
    {    
        ds3231_cntl_stat_t rtc_control_status = {0,0};     
        ds3231_calendar_t rtc_calendar={0,0,0,0};
        rtc.set_cntl_stat_reg(rtc_control_status);              
        rtc.get_calendar(&rtc_calendar); 
        year=rtc_calendar.year; 
        month=rtc_calendar.month;
        date=rtc_calendar.date;
        lcd.cls(); 
        lcd.locate(0,0);   
        lcd.printf("\nFecha:%02d/%02d/%02d",date,month,year); 
        wait(4);
        lcd.cls();  
    }
    
void MostrarHora()
    {
        ds3231_time_t rtc_time={0,0,0,0,0};
        lcd.cls(); 
        lcd.locate(0,0);         
        rtc.get_time(&rtc_time);
        hours=rtc_time.hours; 
        minutes=rtc_time.minutes;
        seconds=rtc_time.seconds;
        lcd.printf("\nHora:%02d:%02d:%02d",hours,minutes,seconds);
        wait(4);
        lcd.cls(); 
    }

void mensajePicoYPlaca(bool picoYPlaca)
    {
        if (picoYPlaca)
            {
                imprimir(0,0,"  Se encuentra",true);
                imprimir(0,1,"en pico y placa",false);
                rtn_val = rtc.set_alarm(alarm, true);
            }
        else
            {
                imprimir(0,0,"No se encuentra",true);
                imprimir(0,1,"en pico y placa",false);
                rtn_val = rtc.set_alarm(alarm, false);
            }
        wait(4);
        lcd.cls();                 
    }
    
bool horaPicoYPlaca(int h, int m)//Para poner los limietes de las horas del pico y placa
    {
        if(h >= 7 && (h <= 8 && m <= 30))
            {
                return true;
            }
        else if (h < 19 && (h >= 17 && m >= 30))
            {
                return true;
            }
        else
            {
                return false;
            }                
    }
   
void calcularPicoYPlaca(int udp, int dia, int hora, int minuto)//Para calcular el pico y placa
    {
    bool horaPyP = horaPicoYPlaca(hora, minuto);
    switch(dia)
        {
            case 0: 
                mensajePicoYPlaca(false);
            break;  
            case 1:
                if((udp==2 || udp==3 || udp==4 || udp==5)&& horaPyP)
                    {
                        mensajePicoYPlaca(true);
                    }
                else{
                        mensajePicoYPlaca(false);
                    }
            break;
            case 2:
                if((udp==6 || udp==7 || udp==8 || udp==9)&& horaPyP)
                    {
                        mensajePicoYPlaca(true);
                    }
                else{
                        mensajePicoYPlaca(false);
                    }
            break;
            case 3:
                if((udp==0 || udp==1 || udp==2 || udp==3)&& horaPyP)
                    {
                        mensajePicoYPlaca(true);
                    }
                else{
                        mensajePicoYPlaca(false);
                    }
            break;
            case 4:
                if((udp==4 || udp==5 || udp==6 || udp==7)&& horaPyP)
                    {
                        mensajePicoYPlaca(true);
                    }
                else{
                        mensajePicoYPlaca(false);
                    }
            break;
            case 5:
                if((udp==8 || udp==9 || udp==0 || udp==1) && horaPyP)
                    {
                        mensajePicoYPlaca(true);
                    }
                else{
                        mensajePicoYPlaca(false);
                    }
            break;
            case 6:
                mensajePicoYPlaca(false);
            break;            
        }  
    }

int ObtenerNumero(const char * datoParaMostrar, int rangoInicial, int rangoFinal)
    { //Para obtener los diferentes numeros del encoder
        int resultado = rangoInicial;
        imprimir(0,0,datoParaMostrar,true);
        lcd.locate(1,1);
        lcd.printf("%d",resultado);
        
        while(true) 
        {
            diferencia=encoder.getPulses()-cambio;
            cambio=encoder.getPulses();
            if(diferencia>0)
            {        
                if(resultado+diferencia >= rangoFinal)
                {
                    resultado = rangoFinal;
                    imprimir(1,1,"   ",false);
                    lcd.locate(1,1);
                    lcd.printf("%d",resultado);
                }
                else
                {
                    resultado+=diferencia;
                    imprimir(1,1,"   ",false);            
                    lcd.locate(1,1);
                    lcd.printf("%d",resultado);
                }
            }        
            else if(diferencia<0)
            {
                if(resultado+diferencia < rangoInicial)
                {
                    resultado = rangoInicial;
                    imprimir(1,1,"   ",false);
                    lcd.locate(1,1);
                    lcd.printf("%d",resultado);
                }
                else
                {
                    resultado+=diferencia;
                    imprimir(1,1,"   ",false);
                    lcd.locate(1,1);
                    lcd.printf("%d",resultado);
                }
            }
            if (mybutton == 0) //Para identificar si esta en pico y placa
            {   
                    break;     //sale del bucle si se pulsa el swich
            }
            wait(0.1);
         
        }
        wait(0.5);       
        return resultado;
    }
    
int main() {          
    Saludo();   
    MostrarFecha();   
    
    int dayWeek = ObtenerNumero("Day of the week",0,6);
    int date = ObtenerNumero("Date",1,31); 
    int month = ObtenerNumero("Month",1,12);      
    int year = ObtenerNumero("Year",15,22);              
      
    ds3231_calendar_t rtc_calendar={dayWeek,date,month,year};
    rtc.set_calendar(rtc_calendar); 
    rtc.get_calendar(&rtc_calendar); 
    lcd.cls();  
    lcd.locate(0,0);
    lcd.printf("\nFecha:%02d/%02d/%02d",date,month,year);
    wait(4);  
    
    imprimir(0,0,"Time Set",true);    
    wait(1);                      
    
    MostrarHora();
    
    int hours = ObtenerNumero("Hours",0,23); 
    int minutes = ObtenerNumero("Minutes",0,59);      
    int seconds = ObtenerNumero("Seconds",0,59);                
    
    lcd.cls();    
    ds3231_time_t rtc_time={0,0,hours,minutes,seconds};
    rtc.set_time(rtc_time);
    rtc.get_time(&rtc_time); 
    lcd.locate(0,0);
    lcd.printf("\nHora:%02d:%02d:%02d", hours,minutes,seconds );
    wait(4); 
    
    imprimir(0,0,"Hour Set",true);      
    wait(1);  
        
    int digitoPlaca = ObtenerNumero("Ultimo # Placa",0,9); 
            
    calcularPicoYPlaca(digitoPlaca,dayWeek,hours,minutes);
    
    imprimir(0,0,"     Feliz",true); //Mensaje de despedida
    imprimir(0,1,"      dia!",false); 
 }
