#include "mbed.h"

//tx, rx, baud rate
Serial pc(USBTX, USBRX,9600); 
Serial blue(PTC15, PTC14, 115200); // for comm with bluetooth hc06
Serial other(PTC17, PTC16, 115200);// for comm with S32K
Ticker locker;

char prev = 'z';   //init states for use to determine if car needs to be locked
char current = 'y';
bool nflag = true;

// A callback function used to determine if car needs to be locked
// it is called 
void lockCar()
{
    pc.printf("ticker\r\n\r");
    char send[] = "bj";
    
    //checks to see if not already locked
    if(nflag)
    {
        //if no new key is pressed lock car
        if(prev == current)
        {
            //stops motor.
            for(int i = 1; i< 50; i++){other.putc(send[1]);}
            wait(5);
            //locks car
            for(int i = 1; i< 50; i++){other.putc(send[0]);}
            prev = 'z';
            nflag = false;
        }
        else
        {
            prev = current;    
        }
    }   
}

int main()
{
    int i = 0;//init variables
    int j = 0;
    char hold[100] ="String";
    //attaches the callback function to a timer
    locker.attach(&lockCar, 20.0);
    pc.printf(hold);
    //controlling loop
    while (true)
     {
        //read from bluetooth if something is avalible
        while(blue.readable())
        {
            //puts characters from bluetooth in buffer
            hold[j++] = blue.getc();
            i = 10;
            nflag = true;
        }
        
        //if buffer has elements
        while(i)
        {
            //put null at end of string
            hold[j] = '\0';
            //send element to S32K
            other.putc(hold[0]);
            //update flag for locking system
            current = hold[0];
            //display info to tera term
            pc.printf("%d:", i);
            pc.printf(hold);
            pc.putc('\n');
            pc.putc('\r');   
            i--;
        }
        
        j = 0;
        i=0;
    }
}