#include "mbed.h"

Timeout response;

DigitalOut green(LED_GREEN);
DigitalOut red(LED_RED);
DigitalIn  sw2(SW2);
DigitalIn  motion(D7);
Serial pc(USBTX, USBRX );

Serial blue(PTC15, PTC14); //tx, rx

void Alert() {
    printf("TimeOut\n\r");
    green = 1;
    red = 0;
    int run = 1000;
    while(run--){
        blue.putc('F');
    }
    printf("Alert Sent\n\r");
/*    
    run = 100;
    while(run--){
        blue.putc('G');
    }
    printf("Turned off\n\r");
*/
}


int main()
{
    int i = 0;
    //char r[5] = {'a'};
    char send = 'Z';
    char hold = 'a';
    char correct = 'C';
    
    pc.baud(9600);
    blue.baud(9600);
    printf("Master Connecting to Slave:\n\r");
    
    while (send!='R') {
      
        blue.putc(send);
        wait(0.5f); // wait a small period of time       

        if(blue.readable())
        {
            while(hold!='X'){
                hold = blue.getc();
            }
            if(hold=='X')
            {   
                printf("Ack Recieved from Slave: Sytem Ready!\n\r");
                send = 'R'; //System Ready
            } 
        }
        wait(0.5f); // wait a small period of time        
        i++; // increment the variable
        green = !green; // toggle a led
    }
    
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    while(1)
    {
        while(motion)
        {   
            printf("Motion Detected\n\r");
            
            if(sw2==1){
                response.attach(&Alert, 2.0);
                blue.putc('A');
                green=0;
                red = 0;
            }
            else{
                printf("Sw2 pressed\n\r");
                response.detach();
                printf("Correct Password\n\r");
                int run = 1000;
                while(run--){
                    blue.putc(correct);
                    red = 1;
                    green = 0;
                }
                wait(3);
            }         
        }        
    }
}
