/* Gatech ECE2035 2015 SPRING PAC MAN
 * Copyright (c) 2015 Gatech ECE2035
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
/** @file main.cpp */
// Include header files for platform
#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include "Speaker.h"

// Include header files for pacman project
#include "globals.h"
#include "map_public.h"
#include "pacman.h"
#include "ghost.h"
#include "MMA8452.h"
#include "doubly_linked_list.h"

// Platform initialization
DigitalIn left_pb(p21);   // push botton
DigitalIn right_pb(p22);  // push botton
DigitalIn up_pb(p23);     // push botton
DigitalIn down_pb(p24);   // push botton
DigitalOut red_led(p25);   // red LED
DigitalOut green_led(p19); // green LED
uLCD_4DGL uLCD(p9,p10,p11); // LCD (serial tx, serial rx, reset pin;)
Serial pc(USBTX,USBRX);     // used by Accelerometer
MMA8452 acc(p28, p27, 100000); // Accelerometer
AnalogOut DACout(p18);      // speaker
Speaker mySpeaker(p18);
wave_player waver(&DACout); // wav player
SDFileSystem sd(p5, p6, p7, p8, "sd"); // SD card and filesystem (mosi, miso, sck, cs)

// Example of the decleration of your implementation
void playSound(char * wav);


/** Main() is where you start your implementation
    @brief The hints of implementation are in the comments. <br>
    @brief You are expected to implement your code in main.cpp and pacman.cpp. But you could modify any code if you want to make the game work better.
*/










// Menu variables
int selection = 0;
int difficulty = 1; // Default difficulty is lvl1
int setselect = 1;
 
// Waits until a big enough change in joystick to select direction
int getInput() {
    int direction = -1;
    
    while(direction < 0) {
        wait(0.01);
    
        if(!left_pb)
            direction = 0;
        else if(!right_pb)
            direction = 2;
        else if(!down_pb)
            direction = 3;
        else if(!up_pb)
            direction = 1;
    }
    
    return direction;
}
 
 
// Settings menu loop
void settings() {
    uLCD.locate(5,4);
    uLCD.printf("Easy Mode");
    uLCD.locate(5,11);
    uLCD.printf("Hard Mode");
    uLCD.locate(1,1);
    uLCD.printf("Press left to go  back");
    
    if(setselect == 1)
        uLCD.line(22, 42, 106, 42, WHITE);
    else
        uLCD.line(22, 98, 106, 98, WHITE);
    
    int direction = getInput();
    
    while(direction !=0 ) {
        if(direction == 1 && setselect == 2) {
            uLCD.line(22, 98, 106, 98, BLACK);   
            uLCD.line(22, 42, 106, 42, WHITE);
            setselect = 1;
        }
        else if(direction == 3 && setselect == 1) {
            uLCD.line(22, 42, 106, 42, BLACK);
            uLCD.line(22, 98, 106, 98, WHITE);
            setselect = 2;   
        }
        
        direction = getInput();
    }
    
    difficulty = setselect;
    uLCD.cls();
    wait(0.2);
}
 
void game() {
    int tick, pre_tick;
    int old_pbleft=1;
    int old_pbright=1;
    int old_pbdown=1;
    int old_pbup=1;
    int win=1;
    int new_pbleft, new_pbright, new_pbdown, new_pbup;
    int temp;
    int isCheat = 0;
    double gx, gy, gz;
    srand (time(NULL));
    Timer timer;
    timer.start();
    tick = timer.read_ms();
    pre_tick = tick;
    
    while((map_remaining_cookie() > 0)) {
            red_led = 0;
            green_led = 1;
            new_pbleft = left_pb;
            new_pbright = right_pb;
            new_pbup = up_pb;
            new_pbdown = down_pb;  
            tick = timer.read_ms(); // Read current time

        
            /// 2. Implement the code to get user input and update the Pacman
            /// -[Hint] Implement the code to move Pacman. You could use either push-button or accelerometer. <br>
            /// The accelerometer's function readXYZGravity() might be useful. 
            if((new_pbleft==0) && (old_pbleft==1)) {
                pacman_set_action(PACMAN_HEADING_LEFT);    
            }
            if((new_pbright==0) && (old_pbright==1)) {
                pacman_set_action(PACMAN_HEADING_RIGHT);    
            }
            if((new_pbup==0) && (old_pbup==1)) {
                pacman_set_action(PACMAN_HEADING_UP);    
            }
            if((new_pbdown==0) && (old_pbdown==1)) {
                pacman_set_action(PACMAN_HEADING_DOWN);    
            }

            
            if((left_pb + right_pb + up_pb + down_pb) == 2) {
                temp = getScore();
                uLCD.cls();
                wait(0.1);
                uLCD.textbackground_color(BLACK);
                uLCD.color(RED);
                uLCD.locate(4,7);
                if(difficulty == 2) {
                uLCD.printf("Game Over!");
                } else {
                uLCD.printf("Round Over!");
                } 
                uLCD.locate(5,10);
                uLCD.printf("You Won!");
                wait(1);
                uLCD.cls();
                uLCD.locate(0,7);
                uLCD.printf("But you cheated...");
                wait(1); 
                uLCD.cls();
                wait(0.05);
                if((difficulty == 1) && (win == 1)) {
                    difficulty++;
                    map_level2();
                    pacman_init(8,10);
                    setScore(temp);
                    uLCD.locate(0,0);
                    uLCD.printf("score:%d",getScore());
                    if (getLives() == 3) {
                        uLCD.filled_circle(10, 12, 3, PACMAN_COLOR);
                        uLCD.filled_rectangle(10, 11, 13, 13, BLACK);
                        uLCD.filled_circle(19, 12, 3, PACMAN_COLOR);
                        uLCD.filled_rectangle(19, 11, 22, 13, BLACK);
                        uLCD.filled_circle(28, 12, 3, PACMAN_COLOR);
                        uLCD.filled_rectangle(28, 11, 31, 13, BLACK);
                    }
                    else if (getLives() == 2) {
                        uLCD.filled_circle(10, 12, 3, PACMAN_COLOR);
                        uLCD.filled_rectangle(10, 11, 13, 13, BLACK);
                        uLCD.filled_circle(19, 12, 3, PACMAN_COLOR);
                        uLCD.filled_rectangle(19, 11, 22, 13, BLACK);
                    } else {
                        uLCD.filled_circle(10, 12, 3, PACMAN_COLOR);
                        uLCD.filled_rectangle(10, 11, 13, 13, BLACK);
                    }
                    playSound("/sd/wavfiles/pacman_beginning.wav");
                    game();
                    isCheat = 1;
                    break;
                }
                if(getScore() > getHighScore()) {
                    uLCD.color(YELLOW);
                    uLCD.locate(2,7);
                    uLCD.printf("NEW HIGH SCORE!");
                    uLCD.locate(4,8);
                    uLCD.printf("score:%d",getScore());
                    uLCD.color(RED);
                    setHighScore(getScore());
                    playSound("/sd/wavfiles/fanfare.wav");
                    difficulty = 1;
                    wait(1);
                    uLCD.cls();
                    isCheat = 1;
                    break;
                } else {
                    uLCD.color(YELLOW);
                    uLCD.locate(1,6);
                    uLCD.printf("You didn't beat\n the high score.");
                    uLCD.locate(1,9);
                    uLCD.printf("Current high\n score: %d",getHighScore());
                    difficulty = 1;
                    uLCD.color(RED);
                    wait(4);
                    uLCD.cls();
                    isCheat = 1;
                    break;
                } 
                
            }
                
            
            old_pbleft = new_pbleft;
            old_pbright = new_pbright;
            old_pbup = new_pbup;
            old_pbdown = new_pbdown;
            if((tick-pre_tick)>500){ // Time step control
                pre_tick = tick;
                ghost_random_walk();
                acc.readXYZGravity(&gx,&gy,&gz);
                if((gx > 0.3) && (abs(gx) > abs(gy))) {
                    pacman_set_action(PACMAN_HEADING_RIGHT);    
                }
                if((gx < -0.3) && (abs(gx) > abs(gy))) {
                    pacman_set_action(PACMAN_HEADING_LEFT);    
                }
                if((gy > 0.3) && (abs(gy) > abs(gx))) {
                    pacman_set_action(PACMAN_HEADING_UP);    
                }
                if((gy < -0.3) && (abs(gy) > abs(gx))) {
                    pacman_set_action(PACMAN_HEADING_DOWN);    
                } 
            
            /// 3. Update the Pacman on the screen
            /// -[Hint] You could update the position of Pacman here based on the input at step 2. <br>
                temp = getScore();
                pacman_update_position();
                ghost_show(get_ghost_list());
                if( temp < getScore()) {
                    green_led = 0;
                    wait(0.05);
                    green_led = 1;
                    temp++;
                    if (temp < getScore()) {
                    playSound("/sd/wavfiles/pacman_eatfruit.wav");
                    } else {
                    mySpeaker.PlayNote(700.0, 0.05, 0.5);
                    mySpeaker.PlayNote(625.0, 0.05, 0.5);
                    }
                }
                
            }
    }
    if (isCheat != 1) {
        uLCD.cls();
        wait(0.2);
        uLCD.textbackground_color(BLACK);
        uLCD.color(RED);
        uLCD.locate(4,7);
        if(difficulty == 2) {
        uLCD.printf("Game Over!");
        } else {
        uLCD.printf("Round Over!");
        }   
        if(win == 1) {
            uLCD.locate(5,10);
            uLCD.printf("You Won!");
        } else {
            uLCD.locate(5,10);
            uLCD.printf("You Lose!");
        }
        wait(2);  
        uLCD.cls();
        wait(0.1);
        if((difficulty == 1) && (win == 1)) {
            difficulty++;
            temp = getScore();
            uLCD.cls();
            wait(0.1);
            map_level2();
            pacman_init(8,10);
            setScore(temp);
            uLCD.locate(0,0);
            uLCD.printf("score:%d",getScore());
            if (getLives() == 3) {
                uLCD.filled_circle(10, 12, 3, PACMAN_COLOR);
                uLCD.filled_rectangle(10, 11, 13, 13, BLACK);
                uLCD.filled_circle(19, 12, 3, PACMAN_COLOR);
                uLCD.filled_rectangle(19, 11, 22, 13, BLACK);
                uLCD.filled_circle(28, 12, 3, PACMAN_COLOR);
                uLCD.filled_rectangle(28, 11, 31, 13, BLACK);
            }
            else if (getLives() == 2) {
                uLCD.filled_circle(10, 12, 3, PACMAN_COLOR);
                uLCD.filled_rectangle(10, 11, 13, 13, BLACK);
                uLCD.filled_circle(19, 12, 3, PACMAN_COLOR);
                uLCD.filled_rectangle(19, 11, 22, 13, BLACK);
            } else {
                uLCD.filled_circle(10, 12, 3, PACMAN_COLOR);
                uLCD.filled_rectangle(10, 11, 13, 13, BLACK);
            }
            playSound("/sd/wavfiles/pacman_beginning.wav");
            game();  
        }
        if(getScore() > getHighScore()) {
            uLCD.color(YELLOW);
            uLCD.locate(2,7);
            uLCD.printf("NEW HIGH SCORE!");
            uLCD.locate(4,8);
            uLCD.printf("score:%d",getScore());
            uLCD.color(RED);
            setHighScore(getScore());
            playSound("/sd/wavfiles/fanfare.wav");
            difficulty = 1;
            wait(1);
            uLCD.cls();
        } else {
            uLCD.color(YELLOW);
            uLCD.locate(1,6);
            uLCD.printf("You didn't beat\n the high score.");
            uLCD.locate(1,9);
            uLCD.printf("Current high\n score: %d",getHighScore());
            difficulty = 1;
            uLCD.color(RED);
            wait(4);
            uLCD.cls();
        }
    } 
} 
 
// Help screen loop
void help() {
    uLCD.locate(1,0);
    uLCD.printf("Change difficulty in settings");
    uLCD.locate(1,3);
    uLCD.printf("Use pushbuttons\n to move");
    uLCD.locate(1,6);
    uLCD.printf("Or tilt gamepad\n to move");
    uLCD.locate(1,9);
    uLCD.printf("Avoid the ghosts\n and eat all the\n pellets!");
    uLCD.locate(1,13);
    uLCD.printf("Push left to\n return to main\n menu");
    
    int direction = getInput();
    
    while(direction != 0) {
        direction = getInput();   
    }
    
    uLCD.cls();
    wait(0.2);   
}
 
// Main menu loop
int main() {
    uLCD.baudrate(3000000);
    
    uLCD.textbackground_color(BLACK);
    uLCD.color(RED);
    uLCD.locate(2,1);
    uLCD.printf("High Score: %d",getHighScore());
    uLCD.locate(4,4);
    uLCD.printf("Start Game");
    uLCD.locate(5,7);
    uLCD.printf("Settings");
    uLCD.locate(7,11);
    uLCD.printf("Help");
    uLCD.locate(1,14);
    uLCD.printf("Press right to\n make selection");
    
    uLCD.line(22, 42, 106, 42, WHITE);
    left_pb.mode(PullUp);  // The variable left_pb will be zero when the pushbutton for moving the player left is pressed    
    right_pb.mode(PullUp); // The variable rightt_pb will be zero when the pushbutton for moving the player right is pressed        
    up_pb.mode(PullUp);    //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed
    down_pb.mode(PullUp);  //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed
    wait(.001);
    
    while(1) {
        red_led = 1;
        green_led = 0;
        int direction = getInput();
        
        while(direction == 0)
            direction = getInput();
        
        // If clicked in
        if(direction == 2) {
            if(selection == 0) {
                uLCD.cls();
                wait(0.05);
                if(difficulty == 1) {
                    map_init();
                    pacman_init(8,9);
                    ghost_init();
                    ghost_create(7,9,LRED);
                    ghost_create(9,9,LBLUE);
                    ghost_create(10,9,PINK);
                    ghost_create(6,9,ORNGE);
                    uLCD.filled_circle(10, 12, 3, PACMAN_COLOR);
                    uLCD.filled_rectangle(10, 11, 13, 13, BLACK);
                    uLCD.filled_circle(19, 12, 3, PACMAN_COLOR);
                    uLCD.filled_rectangle(19, 11, 22, 13, BLACK);
                    uLCD.filled_circle(28, 12, 3, PACMAN_COLOR);
                    uLCD.filled_rectangle(28, 11, 31, 13, BLACK);
                    playSound("/sd/wavfiles/pacman_beginning.wav"); 
                } else {
                    map_level2();
                    pacman_init(8,10);
                    uLCD.filled_circle(10, 12, 3, PACMAN_COLOR);
                    uLCD.filled_rectangle(10, 11, 13, 13, BLACK);
                    uLCD.filled_circle(19, 12, 3, PACMAN_COLOR);
                    uLCD.filled_rectangle(19, 11, 22, 13, BLACK);
                    uLCD.filled_circle(28, 12, 3, PACMAN_COLOR);
                    uLCD.filled_rectangle(28, 11, 31, 13, BLACK);
                    playSound("/sd/wavfiles/pacman_beginning.wav");
                }
                game();
            }
            else if(selection == 1) {
                uLCD.cls();
                wait(0.2);
                settings();
                selection = 0;
            }
            else if(selection == 2) {
                uLCD.cls();
                wait(0.2);
                help();
                selection = 0;   
            }
            uLCD.locate(2,1);
            uLCD.printf("High Score: %d",getHighScore());
            uLCD.locate(4,4);
            uLCD.printf("Start Game");
            uLCD.locate(5,7);
            uLCD.printf("Settings");
            uLCD.locate(7,11);
            uLCD.printf("Help");
            uLCD.locate(1,14);
            uLCD.printf("Press right to\n make selection");
            
            uLCD.line(22, 42, 106, 42, WHITE);
        }
        else if(direction == 1 && (selection == 1 || selection == 2)) {
            selection = selection-1;
            if(selection == 0) {  
                uLCD.line(22, 42, 106, 42, WHITE);
                uLCD.line(22, 68, 106, 68, BLACK);
                uLCD.line(22, 98, 106, 98, BLACK);
            }
            else {
                uLCD.line(22, 42, 106, 42, BLACK);
                uLCD.line(22, 68, 106, 68, WHITE);
                uLCD.line(22, 98, 106, 98, BLACK); 
            }
        }
        else if(direction == 3 && (selection == 0 || selection == 1)) {
            selection = selection+1;
            if(selection == 1) {
                uLCD.line(22, 42, 106, 42, BLACK);
                uLCD.line(22, 68, 106, 68, WHITE);
                uLCD.line(22, 98, 106, 98, BLACK);
            }
            else {
                uLCD.line(22, 42, 106, 42, BLACK);
                uLCD.line(22, 68, 106, 68, BLACK);
                uLCD.line(22, 98, 106, 98, WHITE);               
            }
        }
        
        //Wait to essentialially debounce (want to flick switch)
        wait(0.1);
           
    }
}


//int main()
//{   
//    // Initialize the timer
//    /// [Example of time control implementation]
//        /// Here is a rough example to implement the timer control <br><br>
//    int tick, pre_tick;
//    int old_pbleft=1;
//    int old_pbright=1;
//    int old_pbdown=1;
//    int old_pbup=1;
//    int new_pbleft, new_pbright, new_pbdown, new_pbup;
//    int temp;
//    double gx, gy, gz;
//    srand (time(NULL));
//    Timer timer;
//    timer.start();
//    tick = timer.read_ms();
//    pre_tick = tick;
//    
//    // Initialize the buttons        
//    left_pb.mode(PullUp);  // The variable left_pb will be zero when the pushbutton for moving the player left is pressed    
//    right_pb.mode(PullUp); // The variable rightt_pb will be zero when the pushbutton for moving the player right is pressed        
//    up_pb.mode(PullUp);    //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed
//    down_pb.mode(PullUp);  //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed
//    wait(.001);
//    
//    while(1)
//    {
//        /// [Example of the game control implementation]
//        /// Here is the example to initialize the game <br><br>
//        red_led = 1;
//        green_led = 0;
//        uLCD.cls();
//        map_init();
//        // pacman_init(8,9); // Center of the map
//        pacman_init(8,10);
//    
//        //Your code here
//        //Initiate & create & show the ghosts  
//        ghost_init();
//        ghost_create(7,9,LRED);
//        ghost_create(9,9,LBLUE);
//        ghost_create(10,9,PINK);
//        ghost_create(6,9,ORNGE);
//        //[Demo of play sound file]
//        playSound("/sd/wavfiles/pacman_beginning.wav");
//
//    
//        /// 1. Begin the game loop
//        while(map_remaining_cookie() > 0) {
//            red_led = 0;
//            green_led = 1;
//            new_pbleft = left_pb;
//            new_pbright = right_pb;
//            new_pbup = up_pb;
//            new_pbdown = down_pb;  
//            tick = timer.read_ms(); // Read current time
//        
//            /// 2. Implement the code to get user input and update the Pacman
//            /// -[Hint] Implement the code to move Pacman. You could use either push-button or accelerometer. <br>
//            /// The accelerometer's function readXYZGravity() might be useful. 
//            if((new_pbleft==0) && (old_pbleft==1)) {
//                pacman_set_action(PACMAN_HEADING_LEFT);    
//            }
//            if((new_pbright==0) && (old_pbright==1)) {
//                pacman_set_action(PACMAN_HEADING_RIGHT);    
//            }
//            if((new_pbup==0) && (old_pbup==1)) {
//                pacman_set_action(PACMAN_HEADING_UP);    
//            }
//            if((new_pbdown==0) && (old_pbdown==1)) {
//                pacman_set_action(PACMAN_HEADING_DOWN);    
//            }
//            
//            old_pbleft = new_pbleft;
//            old_pbright = new_pbright;
//            old_pbup = new_pbup;
//            old_pbdown = new_pbdown;
//            if((tick-pre_tick)>500){ // Time step control
//                 pre_tick = tick;
//                 uLCD.locate(0,1);
//                 uLCD.printf("x:%lf , y:%lf",gx, gy);
//                acc.readXYZGravity(&gx,&gy,&gz);
//                if((gx > 0.3) && (abs(gx) > abs(gy))) {
//                    pacman_set_action(PACMAN_HEADING_RIGHT);    
//                }
//                if((gx < -0.3) && (abs(gx) > abs(gy))) {
//                    pacman_set_action(PACMAN_HEADING_LEFT);    
//                }
//                if((gy > 0.3) && (abs(gy) > abs(gx))) {
//                    pacman_set_action(PACMAN_HEADING_UP);    
//                }
//                if((gy < -0.3) && (abs(gy) > abs(gx))) {
//                    pacman_set_action(PACMAN_HEADING_DOWN);    
//                } 
//            
//            /// 3. Update the Pacman on the screen
//            /// -[Hint] You could update the position of Pacman here based on the input at step 2. <br>
//                temp = getScore();
//                pacman_update_position();
//                if( temp < getScore()) {
//                    green_led = 0;
//                    wait(0.05);
//                    green_led = 1;
//                    temp++;
//                    if (temp < getScore()) {
//                    playSound("/sd/wavfiles/pacman_eatfruit.wav");
//                    } else {
//                    mySpeaker.PlayNote(700.0, 0.05, 0.5);
//                    mySpeaker.PlayNote(625.0, 0.05, 0.5);
//                    }
//                }
//                
//            }
//        
//        /// 4. Implement the code to check the end of game.
//        /// -[Hint] Check whether the ghost catch the Pacman. Make sure you could always detect that the ghost and Pacman meet on the screen.
//        /// One tricky scenario is that: Pacman is at grid (3,3) and is heading to (3,4), while the ghost is at grid (3,4) and is heading to (3,3).
//        /// Either at time t or t+1, you will see that the Pacman and the ghost are not on the same grid.
//        /// However, the Pacman should be caught by ghost with this movement.
//        /// -[Hint] Check whether Pacman win the game <br>
//       
//        }
//    }
//}



// Example of implementation of your functions
void playSound(char * wav)
{
    // open wav file
    FILE *wave_file;
    wave_file=fopen(wav,"r");

    // play wav file
    waver.play(wave_file);

    // close wav file
    fclose(wave_file);
}

// Blinks given LED
void blinkLE(DigitalOut& led) 
{
    led = 0;
    wait(0.05);
    led = 1;
}
