#include <stdlib.h>
#include <stdio.h>
#include "doubly_linked_list.h"

DLinkedList* create_dlinkedlist(void) {
    DLinkedList* newList = (DLinkedList*)malloc(sizeof(DLinkedList));
    newList->head = NULL;
    newList->tail = NULL;
    newList->current = NULL;
    newList->size = 0;
    return newList;
}

LLNode* create_llnode(void* data) {
    LLNode* newNode = (LLNode*)malloc(sizeof(LLNode));
    newNode->previous = NULL;
    newNode->next = NULL;
    newNode->data = data;
    return newNode;
}

void insertHead(DLinkedList* dLinkedList, void* data){
  LLNode* newNode = create_llnode(data);
  if(dLinkedList->head == NULL){
    dLinkedList->size++;
    dLinkedList->head = newNode;
    dLinkedList->tail = newNode;
  }else{
    dLinkedList->size++;
    newNode->next = dLinkedList->head;
    (dLinkedList->head)->previous = newNode;
    dLinkedList->head = newNode;
  }
}


void insertTail(DLinkedList* dLinkedList, void* data){
  LLNode* newNode = create_llnode(data);
  if(dLinkedList->head == NULL){
    dLinkedList->size++;
    dLinkedList->head = newNode;
    dLinkedList->tail = newNode;
  }else{
    dLinkedList->size++;
    newNode->previous = dLinkedList->tail;
    (dLinkedList->tail)->next = newNode;
    dLinkedList->tail = newNode;
  }
}

int insertAfter(DLinkedList* dLinkedList, void* newData){
  LLNode* newNode = create_llnode(newData);
  if(dLinkedList->current == NULL){
    return 0;
  }else{
    dLinkedList->size++;
    newNode->previous = dLinkedList->current;
    (dLinkedList->current)->next = newNode;
    return 1;
  }
}


int insertBefore(DLinkedList* dLinkedList, void* newData){
  LLNode* newNode = create_llnode(newData);
  if(dLinkedList->current == NULL){
    return 0;
  }else{
    dLinkedList->size++;
    newNode->next = dLinkedList->current;
    (dLinkedList->current)->previous = newNode;
    return 1;
  }
}



void* deleteBackward(DLinkedList* dLinkedList){
  if(dLinkedList->current == NULL){
    return NULL;
  }
  if(dLinkedList->size == 1) {
    free((dLinkedList->current)->data);
    free(dLinkedList->current);
    dLinkedList->head = NULL;
    dLinkedList->tail = NULL;
    dLinkedList->current = NULL;
    dLinkedList->size--;
    return dLinkedList->current;
  }
  if(dLinkedList->current == dLinkedList->head) {
    free((dLinkedList->current)->data);
    free(dLinkedList->current);
    dLinkedList->head = (dLinkedList->current)->next;
    dLinkedList->current = (dLinkedList->current)->previous;
    dLinkedList->size--;
    dLinkedList->current = NULL;
    return dLinkedList->current;  //check to make sure this returns null!
  }else{
    free((dLinkedList->current)->data);
    free(dLinkedList->current);
    if(dLinkedList->current == dLinkedList->head) {
      dLinkedList->head = (dLinkedList->current)->next;
    }
    dLinkedList->current = (dLinkedList->current)->previous;
    dLinkedList->size--;
    return (dLinkedList->current)->data;
  }
}




void* deleteForward(DLinkedList* dLinkedList){
  if(dLinkedList->current == NULL){
    return NULL;
  }
  if(dLinkedList->size == 1) {
    free((dLinkedList->current)->data);
    free(dLinkedList->current);
    dLinkedList->head = NULL;
    dLinkedList->tail = NULL;
    dLinkedList->current = NULL;
    dLinkedList->size--;
    return dLinkedList->current;
  }
  if(dLinkedList->current == dLinkedList->tail) {
    free((dLinkedList->current)->data);
    free(dLinkedList->current);
    dLinkedList->tail = (dLinkedList->current)->previous;
    dLinkedList->current = (dLinkedList->current)->next;
    dLinkedList->size--;
    dLinkedList->current = NULL;
    return dLinkedList->current;   //check to make sure this returns null!
  }else{
    free((dLinkedList->current)->data);
    free(dLinkedList->current);
    if(dLinkedList->current == dLinkedList->tail) {
      dLinkedList->tail = (dLinkedList->current)->previous;
    }
    dLinkedList->current = (dLinkedList->current)->next; //might have next/previous mixed up
    dLinkedList->size--;
    return (dLinkedList->current)->data;
  }
}


void destroyList(DLinkedList* dLinkedList){
  if(dLinkedList->head != NULL){
    getHead(dLinkedList);
    while(deleteForward(dLinkedList)){};
  }
  free(dLinkedList);
}



void* getHead(DLinkedList* dLinkedList){
  dLinkedList->current = dLinkedList->head;
  if(dLinkedList->head == NULL){
    return NULL;
  }
  return (dLinkedList->head)->data;
}



void* getTail(DLinkedList* dLinkedList){
  dLinkedList->current = dLinkedList->tail;
  if(dLinkedList->tail == NULL){
    return NULL;
  }
  return (dLinkedList->tail)->data;
}



void* getCurrent(DLinkedList* dLinkedList){
  if(dLinkedList->current == NULL){
    return NULL;
  }
  return (dLinkedList->current)->data;
}



void* getNext(DLinkedList* dLinkedList){
  if(dLinkedList->current == NULL){
    return NULL;
  }
  dLinkedList->current = (dLinkedList->current)->next;
  if(dLinkedList->current == NULL){
    return NULL;
  }
  return (dLinkedList->current)->data;
}



void* getPrevious(DLinkedList* dLinkedList){
  if(dLinkedList->current == NULL){
    return NULL;
  }
  dLinkedList->current = (dLinkedList->current)->previous;
  if(dLinkedList->current == NULL){
    return NULL;
  }
  return (dLinkedList->current)->data;
}


int getSize(DLinkedList* dLinkedList){
  return dLinkedList->size;
}