#include "mbed.h"
#include "LCD12864.h"

DigitalOut myled(PB_1);
DigitalIn Senslev(PA_8);

Serial RFData(PA_2, PA_3);//was PA_2,PA_3
//Serial pc(USBTX,USBRX);
SPI QCOUNT(PB_5, PB_4, PB_3);
Timer Duty;
Timer Cycle;
int Td,T;
LCD12864RSPI mylcd;

float Store[10];
float Average(float* array);
char TxtBuf[17] = "Hier staat niets";
int n = 0;
//************
// Circular buffers for serial TX and RX data - used by interrupt routines
extern const int buffer_size = 255;
// might need to increase buffer size for high baud rates
extern char tx_buffer[buffer_size+1];
extern char rx_buffer[buffer_size+1];
// Circular buffer pointers
// volatile makes read-modify-write atomic 
extern volatile int tx_in;
extern volatile int tx_out;
extern volatile int rx_in;
extern volatile int rx_out;
// Line buffers for sprintf and sscanf
extern char tx_line[80];
extern char rx_line[80];
extern void read_line(void);
//*************
void Catch(void)
{
    myled=1;
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((RFData.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = RFData.getc();
// Uncomment to Echo to USB serial to watch data flow
//        monitor_device.putc(rx_buffer[rx_in]);
        rx_in = (rx_in + 1) % buffer_size;
    }
    myled=0;
    return;

}
/*
   // get the current time from the terminal
    struct tm t;
    printf("Enter current date and time:\n");
    printf("YYYY MM DD HH MM SS[enter]\n");
    scanf("%d %d %d %d %d %d", &t.tm_year, &t.tm_mon, &t.tm_mday
                             , &t.tm_hour, &t.tm_min, &t.tm_sec);

    // adjust for tm structure required values
    t.tm_year = t.tm_year - 1900;
    t.tm_mon = t.tm_mon - 1;

    // set the time
    set_time(mktime(&t));

    // display the time
    while(1) {
        time_t seconds = time(NULL);
        printf("Time as a basic string = %s", ctime(&seconds));
        wait(1);
    }

int tm_sec //seconds after the minute – [0, 60][@1]    (public member object)
int tm_min  //minutes after the hour – [0, 59]    (public member object)
int tm_hour //hours since midnight – [0, 23]    (public member object)
int tm_mday //day of the month – [1, 31]    (public member object)
int tm_mon  //months since January – [0, 11]    (public member object)
int tm_year //years since 1900    (public member object)
int tm_wday //days since Sunday – [0, 6]    (public member object)
int tm_yday //days since January 1 – [0, 365]
int tm_isdst    //Daylight Saving Time flag. The value is positive if DST is in effect, zero if
                       //not and negative if no information is available    (public member object)
*/
struct tm t;

int main()
{
    QCOUNT.format(8,0);         //dac 13bit, res = 8192
    QCOUNT.frequency(10000);
    
    RFData.format(8,SerialBase::None, 1);
    RFData.baud(4800);
    
    t.tm_sec = 00;
    t.tm_min = 17;
    t.tm_hour = 15;
    t.tm_mday = 2;
    t.tm_mon = 0;
    t.tm_year = 2017 - 1900;
    t.tm_wday = 1;
    t.tm_yday = 2;
    t.tm_isdst = 1;

    char timeBuf[30];
    char *ptimeBuf = timeBuf;
    char Buf[16];
    char *pBuf = Buf;
    
    set_time(mktime(&t));
    time_t seconds = time(NULL);
    sprintf(ptimeBuf, "%s", ctime(&seconds));

    mylcd.Initialise();  //was initialise
    mylcd.CLEAR();
    mylcd.DisplayString(0, 0, "Temperatuur = ", 14);
    mylcd.DisplayString(2, 0, ptimeBuf, 11);
    mylcd.DisplayString(3, 0, ptimeBuf + 11 , 13);

    wait_ms(100);

    int i = 0;
    strcpy(rx_buffer, TxtBuf);
    RFData.attach(&Catch, Serial::RxIrq);
    __enable_irq();
    rx_in = 0;
    while(1) {
        
/*
        while (Senslev) {}; //synchrounise level rise

        while (!Senslev) {};
        Duty.start();
        Cycle.start();


        while (Senslev) {};
        Duty.stop();
        Td = Duty.read_us();
        Duty.reset();

        while (!Senslev) {};
        Cycle.stop();
        T = Cycle.read_us();
        Cycle.reset();

        Store[i] = 212.77f * Td/T - 68.08f;
        wait(1);//was 10
        myled = !myled;
        i++;

        //do temp calculation
        //......
        if(i == 10) {


            float temp = Average(Store);


            sprintf(pBuf, "%2.2f", temp);
            *(pBuf + 5) = ' ';  //symbol graden chinees
            *(pBuf + 6) = 'C';
            *(pBuf + 7) = '\0';

            time_t seconds = time(NULL);
            sprintf(ptimeBuf, "%s", ctime(&seconds));
            mylcd.DisplayString(1, 0, pBuf, strlen(pBuf));
//            mylcd.DisplayString(2, 0, ptimeBuf, 11);
            mylcd.DisplayString(3, 0, ptimeBuf + 11 , 13);

            i = 0;
        }
*/


//            read_line();
            mylcd.DisplayString(2, 0, rx_line, 16);//strlen(pBuf));
            
    }
}

float Average(float* array)
{
    float Result = 0;

    for(int i = 0; i < 10; i++)
        Result += *(array + i);

    return Result/10;
}