/*
  Arduino library v1.0
  Demo LCD12864 spi
  www.dfrobot.com
  Version 0.0
 
  Update in Februray 26th, 2013
  Library is applied to Arduino 1.0
  Having added a "initDriverPin" function that allows users to define the SPI interface
  Version 1.0
*/
#include "mbed.h"
#include "LCD12864.h"

SPI LCD(PB_5, PB_4, PB_3);      //PA_7,PA_6,PA_5 LS7366 Quadrature counter
DigitalOut CS_LCD(PA_11);      // PA_4 = PA8

void LCD12864RSPI::WriteByte(int dat)
{

    CS_LCD = 1;
    wait_ms(80);    //was 80ms
    LCD.write(dat); //msbit first
    CS_LCD = 0;
}


void LCD12864RSPI::WriteCommand(int CMD)
{
   int H_data,L_data;
   H_data = CMD;
   H_data &= 0xf0;           //ÆÁ±ÎµÍ4Î»µÄÊý¾Ý
   L_data = CMD;             //xxxx0000¸ñÊ½
   L_data &= 0x0f;           //ÆÁ±Î¸ß4Î»µÄÊý¾Ý
   L_data <<= 4;             //xxxx0000¸ñÊ½
   WriteByte(0xf8);          //RS=0£¬Ð´ÈëµÄÊÇÖ¸Áî£»
   WriteByte(H_data);
   WriteByte(L_data);
}


void LCD12864RSPI::WriteData(int CMD)
{
   int H_data,L_data;
   H_data = CMD;
   H_data &= 0xf0;           //ÆÁ±ÎµÍ4Î»µÄÊý¾Ý
   L_data = CMD;             //xxxx0000¸ñÊ½
   L_data &= 0x0f;           //ÆÁ±Î¸ß4Î»µÄÊý¾Ý
   L_data <<= 4;             //xxxx0000¸ñÊ½
   WriteByte(0xfa);          //RS=1£¬Ð´ÈëµÄÊÇÊý¾Ý
   WriteByte(H_data);
   WriteByte(L_data);
}



void LCD12864RSPI::Initialise()
{
    LCD.format(8,3);         //dac 13bit, res = 8192 
    LCD.frequency(10000);
    CS_LCD = 0;
    wait_ms(80);;

    WriteCommand(0x30);        //¹¦ÄÜÉè¶¨¿ØÖÆ×Ö
    WriteCommand(0x0c);        //ÏÔÊ¾¿ª¹Ø¿ØÖÆ×Ö
    WriteCommand(0x01);        //Çå³ýÆÁÄ»¿ØÖÆ×Ö
    WriteCommand(0x06);        //½øÈëÉè¶¨µã¿ØÖÆ×Ö
}


void LCD12864RSPI::CLEAR(void)
{  
    WriteCommand(0x30);//
    WriteCommand(0x01);//Çå³ýÏÔÊ¾
}


void LCD12864RSPI::DisplayString(int X,int Y, char *ptr,int dat)
{
  int i;

  switch(X)
   {
     case 0:  Y|=0x80;break;

     case 1:  Y|=0x90;break;

     case 2:  Y|=0x88;break;

     case 3:  Y|=0x98;break;

     default: break;
   }

  WriteCommand(Y); // ¶¨Î»ÏÔÊ¾ÆðÊ¼µØÖ·

  for(i=0;i<dat;i++)
    { 
      WriteData(ptr[i]);//ÏÔÊ¾ºº×ÖÊ±×¢ÒâÂëÖµ£¬Á¬ÐøÁ½¸öÂë±íÊ¾Ò»¸öºº×Ö
    }
}



void LCD12864RSPI::DisplaySig(int M,int N,int sig)
{
  switch(M)
   {
     case 0:  N|=0x80;break;

     case 1:  N|=0x90;break;

     case 2:  N|=0x88;break;

     case 3:  N|=0x98;break;

     default: break;
   }
  WriteCommand(N); // ¶¨Î»ÏÔÊ¾ÆðÊ¼µØÖ·
  WriteData(sig); //Êä³öµ¥¸ö×Ö·û
 }




void LCD12864RSPI::DrawFullScreen(uchar *p)
{
      int ygroup,x,y,i;
      int temp;
      int tmp;
             
      for(ygroup=0;ygroup<64;ygroup++)           //Ð´ÈëÒº¾§ÉÏ°ëÍ¼Ïó²¿·Ö
        {                           //Ð´Èë×ø±ê
           if(ygroup<32)
            {
             x=0x80;
             y=ygroup+0x80;
            }
           else 
            {
              x=0x88;
              y=ygroup-32+0x80;    
            }         
           WriteCommand(0x34);        //Ð´ÈëÀ©³äÖ¸ÁîÃüÁî
           WriteCommand(y);           //Ð´ÈëyÖá×ø±ê
           WriteCommand(x);           //Ð´ÈëxÖá×ø±ê
           WriteCommand(0x30);        //Ð´Èë»ù±¾Ö¸ÁîÃüÁî
           tmp=ygroup*16;
           for(i=0;i<16;i++)
         {
            temp=p[tmp++];
            WriteData(temp);
               }
          }
        WriteCommand(0x34);        //Ð´ÈëÀ©³äÖ¸ÁîÃüÁî
        WriteCommand(0x36);        //ÏÔÊ¾Í¼Ïó
}



void LCD12864RSPI::img1(uchar img[])
{
    unsigned int i;
    unsigned char page,column;  

    for(page=0xB0;page<0xB4;page++)  
    {  
        WriteCommand(page);  //set page address   
        WriteCommand(0x10);  //set Column address MSB   
        WriteCommand(0x04);  //set column address LSB 
        
        i = (0xB3-page)*128;
        
        for(column=0;column<128;column++)  
        {  
            WriteData(~img[i+column]);  
        } 
    } 
        WriteCommand(0x34);        //Ð´ÈëÀ©³äÖ¸ÁîÃüÁî
        WriteCommand(0x36);        //ÏÔÊ¾Í¼Ïó 
}

void LCD12864RSPI::img2(uchar img[])
{
    unsigned int i;
    unsigned char page,column;  

    for(page=0xB4;page<0xB8;page++)  
    {  
        WriteCommand(page);  //set page address   
        WriteCommand(0x10);  //set Column address MSB   
        WriteCommand(0x04);  //set column address LSB 
        
        i = (0xB7-page)*128;
        
        for(column=0;column<128;column++)  
        {  
            WriteData(~img[i+column]);  
        } 
    }  
        WriteCommand(0x34);        //Ð´ÈëÀ©³äÖ¸ÁîÃüÁî
        WriteCommand(0x36);        //ÏÔÊ¾Í¼Ïó
}
